/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: paths.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_PATHS_H__
#define	__STD_PATHS_H__

#ifndef	__STD_SYSID_H__
#include <std/sysid.h>
#endif

#ifndef	PATHS_H_MISSING
#include <paths.h>
#endif

#ifdef	_PATH_DEV
#ifndef	_PATH_TTY
#define	_PATH_TTY	_PATH_DEV "tty"
#endif
#ifndef	_PATH_PTY
#define	_PATH_PTY	_PATH_DEV "pty"
#endif
#ifndef	_PATH_LOG
#define	_PATH_LOG	_PATH_DEV "log"
#endif
#ifndef	_PATH_DEVNULL
#define	_PATH_DEVNULL	_PATH_DEV "null"
#endif
#ifndef	_PATH_CONSOLE
#define	_PATH_CONSOLE	_PATH_DEV "console"
#endif
#ifndef	_PATH_MEM
#define	_PATH_MEM	_PATH_DEV "mem"
#endif
#ifndef	_PATH_KMEM
#define	_PATH_KMEM	_PATH_DEV "kmem"
#endif
#else
#define	_PATH_DEV	"/dev/"
#endif

#ifndef	_PATH_DEFPATH
#define	_PATH_DEFPATH		"/usr/local/bin:/usr/bin:/bin:."
#define	_PATH_DEFPATH_ROOT	"/sbin:/bin:/usr/sbin:/usr/bin"
#endif

#ifndef	_PATH_SHELL
#ifdef	_PATH_BSHELL
#define	_PATH_SHELL	_PATH_BSHELL
#else
#define	_PATH_SHELL	"/bin/sh"
#endif
#endif

#ifndef	_PATH_LOGIN
#define	_PATH_LOGIN	"/bin/login"
#endif

#ifndef	_PATH_SENDMAIL
#define	_PATH_SENDMAIL	"/usr/bin/sendmail"
#endif

#ifndef	_PATH_UNIX
#define	_PATH_UNIX	"/unix"
#endif

#ifndef	_PATH_TMP
#define	_PATH_TMP	"/tmp/"
#endif

#ifndef	_PATH_ETC
#define	_PATH_ETC	"/etc/"
#endif

#ifndef	_PATH_ETC_INET
#define	_PATH_ETC_INET	_PATH_ETC
#endif

#ifndef	_PATH_LOCK
#define	_PATH_LOCK	_PATH_TMP
#endif

#ifdef	_PATH_VARRUN
#ifndef	_PATH_UTMP
#define	_PATH_UTMP	_PATH_VARRUN "utmp"
#endif
#ifndef	_PATH_WTMP
#define	_PATH_WTMP	_PATH_VARRUN "wtmp"
#endif
#ifndef	_PATH_LASTLOG
#define	_PATH_LASTLOG	_PATH_VARRUN "lastlog"
#endif
#endif

#define	searchpath	__NAMESPACE(searchpath)
char	*searchpath(char **list, unsigned long mode);

#endif

