/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: limits.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_LIMITS_H__
#define	__STD_LIMITS_H__

#ifndef	__STD_SYSID_H__
#include <std/sysid.h>
#endif

#include <limits.h>

#ifndef	__CONFIG_H__
#include <_config.h>
#endif

#ifndef	POSIX1_LIM_H_MISSING
#include <posix1_lim.h>
#else
#ifndef	UNISTD_H_MISSING
#include <unistd.h>
#endif

#define	_POSIX1_LIMITS_H	1
#define	_POSIX_ARG_MAX		4096
#define	_POSIX_CHILD_MAX	6
#define	_POSIX_LINK_MAX		8
#define	_POSIX_MAX_CANON	255
#define	_POSIX_MAX_INPUT	255
#define	_POSIX_NGROUPS_MAX	0
#define	_POSIX_OPEN_MAX		16
#define	_POSIX_NAME_MAX		14
#define	_POSIX_PATH_MAX		255
#define	_POSIX_PIPE_BUF		512
#define	_POSIX_SSIZE_MAX	32767
#define	_POSIX_STREAM_MAX	8
#define	_POSIX_TZNAME_MAX	3

#endif

#ifndef	NR_OPEN
#ifdef	OPEN_MAX
#define	NR_OPEN OPEN_MAX
#else
#define	NR_OPEN _POSIX_OPEN_MAX
#endif
#endif


#ifdef	MSDOS
#if !defined(GNU) && !defined(__386__) 
#if defined(__BORLANDC__) && (defined(__SMALL__) || defined(__MEDIUM__))
#define	MEM_SEGMENT_MAX	16
#endif
#if defined(M_I86SM) || defined(M_I86MM))
#define	MEM_SEGMENT_MAX	16
#endif
#endif
#endif

#ifndef	MEM_SEGMENT_MAX
#define	MEM_SEGMENT_MAX	32
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#define	limit_openmax	__NAMESPACE(limit_openmax)
#define	limit_pathmax	__NAMESPACE(limit_pathmax)

int	limit_openmax(int request);
int	limit_pathmax(int request, const char *path);

#ifdef	__cplusplus
}
#endif

#endif
