/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: files.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_FILES_H__
#define	__STD_FILES_H__

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#include <stdio.h>
#include <sys/stat.h>

#ifndef	UNISTD_H_MISSING
#include <unistd.h>
#endif

#ifndef	SYS_FCNTL_H_MISSING
#include <sys/fcntl.h>
#else
#ifndef	FCNTL_H_MISSING
#include <fcntl.h>
#endif
#endif

#ifndef IO_H_MISSING
#include <io.h>
#endif

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif


#ifdef	OFF_T_MISSING
#undef	OFF_T_MISSING
typedef	long	off_t;
#endif

#ifdef	FD_T_MISSING
#undef	FD_T_MISSING
typedef	int	fd_t;
#endif	

#ifndef	O_ACCMODE
#define	O_ACCMODE	(O_RDONLY|O_WRONLY|O_RDWR)
#endif

#ifndef	O_EXLOCK
#define	O_EXLOCK	0
#endif

#ifndef	O_SHLOCK
#define	O_SHLOCK	0
#endif

#ifndef	STDERR_FILENO
#define	STDIN_FILENO	0
#define	STDOUT_FILENO	1
#define	STDERR_FILENO	2
#endif

#ifndef	SEEK_END
#define	SEEK_SET	0
#define	SEEK_CUR	1
#define	SEEK_END	2
#endif

#ifndef	DEFFILEMODE
#define	DEFFILEMODE	(S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH) 
#endif

#ifndef	S_ISDIR
#define	S_ISDIR(m)	((m & 0170000) == 0040000)
#define	S_ISCHR(m)	((m & 0170000) == 0020000)
#define	S_ISBLK(m)	((m & 0170000) == 0060000)
#define	S_ISREG(m)	((m & 0170000) == 0100000)
#define	S_ISFIFO(m)	((m & 0170000) == 0010000)
#endif

#ifndef	S_ISLNK
#define	S_ISLNK(m)	((m & 0170000) == 0120000)
#define	S_ISSOCK(m)	((m & 0170000) == 0140000)
#endif

#endif



