/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: errlog.h 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __STD_ERRLOG_H__
#define __STD_ERRLOG_H__

#ifdef	__IDENT__
#define	_IDENT	__IDENT__ ": "
#else
#define	_IDENT ""
#endif

#ifdef	__DAEMON__

#ifndef	__STD_LOG_H__
#include <std/syslog.h>
#endif

#define	errexit(ex, fmt, args...) \
	{ syslog(LOG_ERR, fmt, ## args); \
	exit(ex); }
#define	errabort(fmt, args...) \
	{ syslog(LOG_ERR, fmt, ## args); \
	abort(); }
#define	errlog(fmt, args...) \
	syslog(LOG_ERR, fmt, ## args)
#else

#ifndef	__STD_FILES_H__
#include <std/files.h>
#endif

#define	errexit(ex, fmt, args...) \
	{ fprintf(stderr, _IDENT fmt, ## args); \
	fputc('\n', stderr); \
	exit(ex); }
#define	errabort(fmt, args...) \
	{ fprintf(stderr, _IDENT fmt, ## args); \
	fputc('\n', stderr); \
	abort(); }
#define	errlog(fmt, args...) \
	{ fprintf(stderr, _IDENT fmt, ## args); \
	fputc('\n', stderr); }
#endif

#ifdef	DEBUG_LEVEL
#ifdef	__DAEMON__
#define	print_debug(lvl, fmt, args...) \
	if(lvl <= DEBUG_LEVEL) \
		syslog(LOG_DEBUG, fmt "\n", ## args)
#else
#define	print_debug(lvl, fmt, args...) \
	if(lvl <= DEBUG_LEVEL) \
		fprintf(stderr, _IDENT fmt "\n", ## args)
#endif
#else
#define	print_debug(lvl, fmt, args...)
#endif

#endif
