/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: conf.h 1.5 Sun, 06 Sep 1998 20:00:30 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__STD_CONFIG_H__
#define	__STD_CONFIG_H__

#ifndef	__STD_TYPES_H__
#include <std/types.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#define	openconf	__NAMESPACE(openconf)
#define	readconf	__NAMESPACE(readconf)
#define	seekconf	__NAMESPACE(seekconf)
#define	getconf		__NAMESPACE(getconf)
#define	getconf2	__NAMESPACE(getconf2)
#define	setconf		__NAMESPACE(setconf)
#define	dupconf		__NAMESPACE(dupconf)
#define	closeconf	__NAMESPACE(closeconf)

int	openconf(const char *path);
char	*readconf(char *buf, int max);
char	*seekconf(const char *seek);
char	*getconf(const char *keyword);
char	*getconf2(void *i, const char *keyword);
void	setconf(void);
void	closeconf(void);
void	*dupconf(void);

#ifdef	__cplusplus
}
#endif

#endif

