/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _trap.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/signal.h>

static	sigjmp_buf	env_timer, env_trap;
static	int	old_trap = 0;

static	void	sig_trap(int signo)
{
	siglongjmp(env_trap, signo);
}

static	void	sig_timer(int signo)
{
	siglongjmp(env_timer, 1);
}

int	timer(int timeout)
{
	alarm(0);
	signal(SIGALRM, SIG_DFL);

	if(!timeout)
		return 0;

	if(sigsetjmp(env_timer, 1))
		return 1;

	signal(SIGALRM, &sig_timer);
	alarm(timeout);
	return 0;
}

int	trap(long trap_mask)
{
	int	signo;

	signo = sigsetjmp(env_trap, 1);

	if(signo)
		return signo;

	if(!trap_mask)
	{
		for(signo = 1; signo < 32; ++signo)
			if(old_trap & (1<<signo))
				signal(signo, SIG_DFL);

		old_trap = 0;
		return 0;
	}
		
	for(signo = 1; signo < 32; ++signo)
	{
		if(trap_mask & (1<<signo))
			signal(signo, &sig_trap);
		else if(old_trap & (1<<signo))
			signal(signo, SIG_DFL);
	}
	old_trap = trap_mask;
	return 0;
}	

