/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _termios.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/termios.h>

#ifdef	TERMIOS_H_MISSING
#ifdef	TERMIO_H_MISSING

/*
 * Create POSIX termios-like functionality under older BSD systems.  This
 * involves mapping many ioctl routines to termios structure items.  This
 * code MAY work with SOME old BSD systems, mileage varies.  In all cases,
 * if posix termios is available, it is preferred.
 */

static	struct	sgttyb	ttyb;
static	struct	tchars	ttyt;
static	struct	ltchars	ttylt;
static	int	localmode;
static	int	ldisc;

#else

/* 
 * Create POSIX termios-like termio for older Sys V UNIX systems.  For
 * the most part, POSIX termios functionality is a superset of termios
 * and largely replaces untyped ioctrl() requests with cleanly typecast
 * wrapper functions.
 */

int	tcgetattr(int fd, struct termios *tp)
{
	return ioctl(fd, TCGETA, (char *)tp);
}

int	tcsetattr(int fd, int mode, struct termios *tp)	
{
	switch(mode)
	{
	}
	return ioctl(fd, TCSETA, (char *)tp);
}

#endif
#endif
