/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _syslog.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <errno.h>
#include <stdarg.h>
#include <std/syslog.h>
#include <std/files.h>
#include <std/time.h>
#include <std/paths.h>

int     printlog(const char *path, const char *prefix, const char *fmt, ...)
{
	va_list arg;
	time_t  now;
	char    buf[1024];
	fd_t    fd;

	va_start(arg, fmt);
	time(&now);
	fd = open(path, O_WRONLY | O_APPEND | O_CREAT, 0640);

	if(prefix)
		strftime(buf, 64, prefix, localtime(&now));
	else
		buf[0] = 0;

	vsprintf(buf + strlen(buf), fmt, arg);
	va_end(arg);
	if(fd < 0)
		return fd;

	write(fd, buf, strlen(buf));
	close(fd);
	return 0;
}

#ifdef  SYSLOG_H_MISSING

static  fd_t    log = -1;
static  int     opt = 0;

static  void    errout(fd_t fd, char *id, int opt, const char *fmt, va_list arg)
{
	int     m = 0;
	char    buf[1024];
	char    out[4096];

	out[0] = 0;

	if(id)
	{
		if(opt & LOG_PID)
			sprintf(out, "%s[%d]: ", id, getpid());
		else
			sprintf(out, "%s: ", id);
	}
	q = buf;
	p = (char *)fmt;

	while(*p)
	{
		switch(*p)
		{
		case 'm':
			if(m)
			{
				strcpy(--q, strerror(errid));
				m = 0;
			}
			else
				*(q++) = *p;
			break;
		case '%':
			if(!m)
				++m;
			*(q++) = *p;
			break;
		default:
			*(q++) = *p;
			m = 0;
		}
		++p;
	}
	*q = 0;
	p -= 2;

	vsprintf(out + strlen(out), buf, arg);

	strcat(out, "\n");

	m = strlen(out);
	
	if(fd < 0)
		fflush(NULL);

	if(fd > -1)
	{
		write(fd, out, m);
		fsync(fd);
	}
	else
	{
		fputs(out, stderr);
		fflush(stderr);
	}

	if(opt & LOG_PERROR)
		if(fd > -1)
		{
			fputs(out, stderr);
			fflush(stderr);
		}
}

static  int     log_opt = 0;

static  fd_t    opendevlog(void)
{
	char    path[80];
	fd_t    fd;

	fd = open(_DEV_LOG, O_WRONLY | O_APPEND);
	    
	if(fd < 0 && id)
	{
		strcpy(path, _PATH_SPOOL "log/");
		strcat(path, id);
		fd = open(path, O_WRONLY | O_APPEND);
	}
	if(fd < 0 && (log_opt & LOG_CONS))
		fd = open(_DEV_CONSOLE, O_WRONLY | O_APPEND);

	return fd;
}

void    openlog(char *ident, int option, int facility)
{
	id = ident;
	opt = option;
	if(option & LOG_NDELAY)
		log = opendevlog();
}

void    closelog(void)
{
	id = NULL;
	opt = 0;
}

void    syslog(int priority, const char *fmt, ...)
{
	va_list arg;

	va_start(arg, fmt);
	if(log < 0)
		log = opendevlog();

	priority = priority & 0x0f;
	if(log > -1 || opt & LOG_CONS)
		errout(log, log_opt, fmt, arg);
	
	va_end(arg);
}

#endif

