/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _strsock.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/socket.h>
#include <std/stream.h>
#include <std/string.h>
#include <std/paths.h>
#include <std/sysid.h>

#ifdef	_CAP_STREAM_FILES

#ifdef	_CAP_UNIX_STREAMS

fd_t	mkstream(const char *name, int mode)
{
	fd_t	so;
	fd_t	fd[2];
	char	dname[256];

	mode = mode & 0666;

	if(*name != '/')
	{
		strcpy(dname, _PATH_DEV);
		strcat(dname, name);
		name = dname;
	}

	unlink(name);

	so = creat(name, mode);
	if(so < 0)
		return -1;

	close(so);
	
	if(stream(fd))
		return -1;

	if(ioctl(fd[1], I_PUSH, "connld") < 0)
	{
		close(fd[1]);
		close(fd[0]);
		return -1;
	}

	if(fattach(fd[1], name))
	{
		close(fd[1]);
		close(fd[0]);
		return -1;
	}

	return fd[0];
}

fd_t	newstream(fd_t so)
{
	struct	strrecvfd recvfd;
	
	if(ioctl(so, I_RECVFD, &recvfd) < 0)
		return -1;

	return recvfd.fd;
}

fd_t	getstream(const char *name)
{
	fd_t	fd = open(name, O_RDWR);

	if(fd < 0)
		return fd;

	if(!isastream(fd))
	{
		close(fd);
		return -1;
	}

	return fd;
}

#else

#include <sys/un.h>

fd_t	mkstream(const char *bindname, int mode)
{
	struct	sockaddr_un	addr;
	fd_t	so;
	int	len;
	struct	stat	ino;

	memset(&addr, 0, sizeof(addr));
	addr.sun_family = AF_UNIX;
	if(*bindname == '/')
		strcpy(addr.sun_path, bindname);	
	else
	{
		strcpy(addr.sun_path, _PATH_DEV);
		strcat(addr.sun_path, bindname);
	}
	so = socket(AF_UNIX, SOCK_STREAM, 0);
	if(so < 0)
		return -1;

	unlink(addr.sun_path);
#ifdef	__SUN_LEN
	len = sizeof(addr.sun_len) + strlen(addr.sun_path) + sizeof(addr.sun_family) + 1;
	addr.sun_len = len;
#else
	len = strlen(addr.sun_path) + sizeof(addr.sun_family);
#endif
	if(bind(so, (struct sockaddr *)&addr, len))
	{
		close(so);
		return -1;
	}

	if(listen(so, 5) < 0)
	{
		close(so);
		unlink(addr.sun_path);
		return -1;
	}
	chmod(addr.sun_path, mode);
	return so; 
}

fd_t	getstream(const char *name)
{
	struct	sockaddr_un	addr;
	fd_t	so;
	int	len;

	if(!name)
		return -1;

	memset(&addr, 0, sizeof(addr));
	addr.sun_family = AF_UNIX;
	strcpy(addr.sun_path, name);
#ifdef	__SUN_LEN
	len = sizeof(addr.sun_len) + sizeof(addr.sun_family) + sizeof(addr.sun_path) + 1;	
	addr.sun_len = len;
#else
	len = sizeof(addr.sun_family) + strlen(addr.sun_path);
#endif	

	so = socket(AF_UNIX, SOCK_STREAM, 0);
	if(so < 0)
		return -1;

	if(connect(so, (struct sockaddr *)&addr, len))
	{
		close(so);
		return -1;
	}
	return so;
}

fd_t	newstream(fd_t so)
{
	struct	sockaddr_un	addr;
	int	len = sizeof(addr);

	return accept(so, (struct sockaddr *)&addr, &len);
}
	
#endif	
#endif
