/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _string.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/string.h>
#include <std/ctype.h>

#ifdef	STRLWR_F_MISSING

char    *strlwr(char *s)
{
	char    *old;

	if(!s)
		return NULL;
		
	old=s;
	while(*s = (char)tolower(*s))
		++s;
	
	return old;
}

char    *strupr(char *s)
{
	char    *old;

	if(!s)
		return NULL;
		
	old=s;
	while(*s = (char)toupper(*s))
		++s;
	return old;
}

#endif

#ifdef	STRDUP_F_MISSING

char	*strdup(str)
char	*str;
{
	char	*new = (char *)malloc(strlen(str) + 1);
	if(!new)
		return NULL;

	return strcpy(new, str);
}

#endif

#ifdef	STRICMP_F_MISSING

int stricmp(const char *s1, const char *s2)
{
	int t;

	while(*s1 && *s2)
	{
		if (t=tolower(*s1)-tolower(*s2))
			return  t;

		++s1;
		++s2;
	}
	return tolower(*s1)-tolower(*s2);
}

int strnicmp(const char *s1,const char *s2, size_t n)
{
	int t;

	while (n--)
	{
		if (t=tolower(*s1)-tolower(*s2))
			return  t;

		if (!*s1)
			return 0;

		++s1;
		++s2;
	}
	return 0;
}

#endif

#ifdef	STRISTR_F_MISSING

char	*stristr(char *s1, const char *s2)
{
	int	len = strlen(s2);
	int	count = strlen(s1) - len + 1;

	while(count--)
	{
		if(!strnicmp(s1, s2, len))
			return s1;
		++s1;
	}
	return NULL;
}

#endif
		
