/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _spawn.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/process.h>
#include <std/files.h>
#include <std/paths.h>

#ifdef	SPAWN_F_MISSING

static	void	spawn_redirect(int io, int mode)
{
	int	fd = open(_PATH_DEVNULL, mode);

	if(fd < 0)
		exit(EX_OSFILE);

	if(fd != io)
	{
		dup2(fd, io);
		close(fd);
	}
}

static	int	spawn_wait(pid_t pid, int mode)
{
	int	waitflag;

	/* -1 on fork failure */

	if(pid == -1)
		return -1;

	switch(mode)
	{
	case P_WAIT:
	case P_BACKGROUND:
		waitpid(pid, &waitflag, 0);
		return WEXITSTATUS(waitflag);
	}
	return pid;
}		
	
static	void	spawn_mode(int mode)
{
	int	i;

	switch(mode)
	{
	case P_NOWAITO:
		setsid();
	case P_BACKGROUND:
		spawn_redirect(0, O_RDONLY);
		spawn_redirect(1, O_WRONLY);
		spawn_redirect(2, O_WRONLY);
	}

	for(i = 3; i < limit_openmax(0); ++i)
		close(i);
}

int	spawnv(const int mode, const char *path, char *const argv[])
{
	pid_t pid = 0;
	int	status;

	if(mode != P_OVERLAY)
		pid = vfork();

	if(pid)
		return spawn_wait(pid, mode);
	
	spawn_mode(mode);
	execv(path, argv);
	exit(EX_UNAVAILABLE);
	return -1;
}

int	spawnvp(const int mode, const char *path, char *const argv[])   
{
	pid_t pid = 0;
	int	status;

	if(!(mode & P_OVERLAY))
		pid = vfork();

	if(pid)
		return spawn_wait(pid, mode); 

	spawn_mode(mode);
	execvp(path, argv);
	exit(EX_UNAVAILABLE);
	return -1;
}

#endif

