/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _sockio.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/socket.h>
#include <std/string.h>

void	endsocket(SOCKET so)
{
#ifdef	SO_LINGER
	struct	linger	linger;

	linger.l_onoff = linger.l_linger = 0;
	setsockopt(so, SOL_SOCKET, SO_LINGER, &linger, sizeof(linger));
#endif
	shutdown(so, 2);
	close(so);
}

SOCKET	mksocket(const char *bindname, short port, int type)
{
	struct	sockaddr_in	addr;
	SOCKET	so;

	if(bindname)
		if(!strcmp(bindname, "*"))
			bindname = NULL;

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	if(!gethostaddr(bindname, &addr.sin_addr))
		return INVALID_SOCKET;

	so = socket(AF_INET, type, 0);
	if(so < 0)
		return INVALID_SOCKET;

	if(bind(so, (struct sockaddr *)&addr, sizeof(addr)))
	{
		endsocket(so);
		return INVALID_SOCKET;
	}
	return so;
}

SOCKET	getsocket(const char *hostname, short port, int type)
{
	struct	sockaddr_in	addr;
	SOCKET	so;

	if(!hostname)
		return INVALID_SOCKET;

	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	if(!gethostaddr(hostname, &addr.sin_addr))
		return INVALID_SOCKET;

	so = socket(AF_INET, type, 0);
	if(so < 0)
		return INVALID_SOCKET;

	if(connect(so, (struct sockaddr *)&addr, sizeof(addr)))
	{
		endsocket(so);
		return INVALID_SOCKET;
	}
	return so;
}

struct	hostent	*gethostinfo(const char *hostname)
{
	static	struct	in_addr	saddr;
	struct	hostent *hp;
	static	struct	hostent	np;
	static	char	host[24];
	static	char	*alias[] = {NULL};
	static	struct	in_addr	*alist[] = {&saddr, NULL};

	if(!hostname)
		return NULL;

	if(isdigit(*hostname))
	{
		saddr.s_addr = inet_addr(hostname);
		hp = gethostbyaddr((void *)&saddr, sizeof(struct in_addr), AF_INET);
		if(hp)
			return hp;
			
		strcpy(host, hostname);
		np.h_name = host;
		np.h_aliases = alias;
		np.h_addrtype = AF_INET;
		np.h_length = 4;
		np.h_addr_list = (char **)alist;
		return &np;
	}
	else
		return gethostbyname(hostname);
}

struct	in_addr *gethostaddr(const char *host, struct in_addr *aptr)
{
	static	union
	{
		struct	in_addr addr;
		long	phyaddr;
	}	ipaddr;

	struct	in_addr	**bptr;

	struct	hostent	*hp;

	if(!aptr)
		aptr = &ipaddr.addr;

	if(!host)
	{
		memset(&ipaddr, 0l, sizeof(ipaddr));
		ipaddr.phyaddr = INADDR_ANY;
		memcpy(aptr, &ipaddr, sizeof(ipaddr));
		return &ipaddr.addr;
	}

	hp = gethostinfo(host);
	if(!hp)
		return NULL;

	bptr = (struct in_addr **)hp->h_addr_list;
	while(*bptr != NULL)
		++bptr;

	--bptr;
	memcpy(aptr, *bptr, sizeof(struct in_addr));
	return aptr;
}

SOCKET	newsocket(SOCKET bind, struct in_addr *aptr)
{
	int	len = sizeof(struct sockaddr_in);
	struct	sockaddr_in	addr;
	SOCKET	so = accept(bind, (struct sockaddr *)&addr, &len);

	if(aptr)
		memcpy(aptr, &addr.sin_addr, sizeof(struct in_addr));

	return so;
}


	

