/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _sockid.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/socket.h>
#include <std/string.h>
#include <std/services.h>

char	*sockident(SOCKET so)
{
	static	char	buf[80];
	struct	sockaddr_in	home, peer, ident;
	int	l1 = sizeof(home);
	int	l2 = sizeof(peer);
	SOCKET	id;
	char	*p;

	if(getsockname(so, (struct sockaddr *)&home, &l1) < 0)
		return NULL;

	if(getpeername(so, (struct sockaddr *)&peer, &l2) < 0)
		return NULL;

	id = socket(AF_INET, SOCK_STREAM, 0);
	if(id == INVALID_SOCKET)
		return NULL;

	memcpy(&ident, &peer, sizeof(peer));
	ident.sin_port = htons(_TCPIP_IDENT);
	if(connect(id, (struct sockaddr *)&ident, sizeof(ident)) < 0)
	{
		endsocket(id);
		return NULL;
	}
	sprintf(buf, "%d,%d\n", ntohs(home.sin_port),
				ntohs(peer.sin_port));

	l1 = strlen(buf);
	if(write(id, buf, l1) < l1)
	{
		endsocket(id);
		return NULL;
	}
	l2 = read(id, buf, sizeof(buf) - 1);
	endsocket(id);
	if(l2 < 1)
		return NULL;

	buf[l2] = 0;	
	p = strtok(buf, ":");
	if(!p)
		return NULL;

	p = strtok(NULL, ":");
	if(!p)
		return NULL;
	p = strtrim(p, NULL);
	if(strcmp(p, "USERID"))
		return NULL;

	p = strtok(NULL, ":\n\r");
	if(!p)
		return NULL;

	return strtok(NULL, ":\n\r\t ");
}
