/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _sem.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/sem.h>

#ifdef	SYS_SEM_H_MISSING
#include <std/paths.h>
#include <std/locking.h>

int	sem_create(const char *name, int mode)
{
	char	path[64];
	fd_t	fd;

	strcpy(path, _PATH_LOCK);
	strcat(path, name);
	strcat(path, ".sem");
	
	fd = open(path, O_RDWR | O_CREAT, mode);
	if(fd < 0)
		return fd;

	return fd;
}

int	sem_lock(int id)
{
	return flock(id, LOCK_EX | LOCK_NB);
}

void	sem_ulock(int id)
{
	flock(id, LOCK_UN);
}

void	sem_release(int id)
{
	flock(id, LOCK_UN);
	close(id);
}
#else

static	struct	sembuf	op_lock[2] =
{
	0, 0, 0,
	0, 1, SEM_UNDO
};

static	struct	sembuf	op_ulock[1] =
{
	0, -1, (IPC_NOWAIT | SEM_UNDO)
};

int	sem_create(const char *id, int mode)
{
	key_t	nid = 0l;
	int	max = 8;

	while(*id && max--)
		nid = (nid << 4) | (*(id++) & 0x0f);

	return semget(nid, 1, mode | IPC_CREAT);
}

int	sem_lock(int id)
{
	return semop(id, &op_lock[0], 2);
}

void	sem_ulock(int id)
{
	semop(id, &op_ulock[0], 1);
}

void	sem_release(int id)
{
	sem_ulock(id);
}
			
#endif
