/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _rwv.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef	SYS_UIO_H_MISSING

#include <std/stream.h>
#include <std/math.h>

static	bufsize = 0;
static	void	*buf = NULL;

static	size_t	balloc(struct iovec *iov, size_t count)
{
	int	old = bufsize;
	size_t	size = 0;
	
	while(count--)
	{
		size += iov->iov_len;
		++iov;
	}

	if(!size)
		return 0;
	
	while(bufsize < size)
		bufsize += getpagesize();
	
	if(old != bufsize)
	{
		if(old)
			free(buf);	
		buf = (void *)malloc(bufsize);
	}
	return size;
}

size_t	writev(fd_t fd, const struct iovec *iov, size_t count)
{
	size_t	size = balloc((struct iovec *)iov, count);
	size_t	c;
	char	*b = buf;
	char	*t;
	size_t	len = size;

	while(count-- && len)
	{
		t = (char *)(iov->iov_base);
		c = min(iov->iov_len, len);
		++iov;
		if(len && c)
			memcpy(b, t, c);
		len -= c;
	}
	return write(fd, buf, size);
}
	 
size_t	readv(fd_t fd, const struct iovec *iov, size_t count)
{
	size_t	size = balloc((struct iovec *)iov, count);
	size_t	c = count;
	char	*b = buf;
	char	*t;
	size_t	len = size;

	len = read(fd, buf, len);
	if(len < 1)
		return len;

	size = len;

	while(count-- && len)
	{
		t = (char *)iov->iov_base;
		c = min(iov->iov_len, len);
		++iov;
		memcpy(t, b, c);
		len -= c;
	}
	return size;
}
			
#endif
