/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _rt.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/rt.h>

#ifdef	SETPRIORITY_F_MISSING

int	rt(int priority)
{
	return nice(-priority - 1);
}

#else

int	rt(int pri)
{
#ifdef	_POSIX_PRIORITY_SCHEDULING
	struct	sched_param	p;
#endif
	int	newpri = getpriority(PRIO_PROCESS, 0) - pri - 1;
	
#ifdef	PRIO_PROCESS
	if(setpriority(PRIO_PROCESS, 0, newpri))
		return -1;
#endif

#ifdef	_POSIX_PRIORITY_SCHEDULING
	if(pri > 0)
	{
		p.sched_priority = sched_get_priority_min(SCHED_RR) + pri - 1;
		if(sched_setscheduler(0, SCHED_RR, &p))
			return -1;
	}
#endif
	return 0;

}

#endif

#ifdef	_POSIX_PRIORITY_SCHEDULING

void	yield(void)
{
	sched_yield();
}

#else

void	yield(void)
{
	sleep(0);
}
#endif

#ifdef	_POSIX_MEMLOCK

#ifndef	STACKSIZE
#define	STACKSIZE	60000
#endif

int	rtlock(void)
{
	int	pages[STACKSIZE];	/* force auto stack space */
	int	i;

	for(i = 1; i < STACKSIZE; i += STACKSIZE / 100)
		pages[i] = 1;

	return mlockall(MCL_CURRENT | MCL_FUTURE);
}

#else

int	rtlock(void)
{
	return -1;
}

#endif
