/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _pty.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/stream.h>
#include <std/paths.h>
#include <std/errno.h>

#ifdef	_CAP_PTY_DEVICES

fd_t	pty_stream(const char *name, int mode)
{
	char	ptyname[33];
	char	devname[65];

	fd_t	dev;

	if(*name == '/')
		devname[0] = 0;
	else
		strcpy(devname, _PATH_DEV);

	if(!mode)
		mode = S_IRUSR | S_IRGRP | S_IWUSR | S_IWGRP;

	strcat(devname, name);
	remove(devname);
	dev = pty_create(ptyname);
	if(dev < 0)
		return dev;
	symlink(ptyname, devname);
	chmod(devname, mode);
	chown(devname, getuid(), getgid());
	return dev;
}

#ifdef	PTSNAME_F_MISSING

fd_t	pty_create(char *pts_name)
{
	fd_t	fd;
	char	*p1, *p2;

	strcpy(pts_name, "/dev/ptyXY");
	for(p1 = "pqrstuvwxyzPQRST"; *p1; p1++)
	{
		pts_name[8] = *p1;
		for(p2 = "0123456789abcdef"; *p2; p2++)
		{
			pts_name[9] = *p2;
			if((fd = open(pts_name, O_RDWR)) < 0)
			{	
				if(errno == ENOENT)
					return -1;
				else
					continue;
			}
			pts_name[5] = 't';
			return fd;
		}
	}
	return -1;
}

fd_t	pty_open(char *pts_name)
{
	return open(pts_name, O_RDWR);
}

#else

fd_t	pty_create(char *ptys_name)
{
	fd_t	fd;
	char	*p;

	strcpy(ptys_name, _PATH_DEV "ptmx");
	if((fd = open(ptys_name, O_RDWR)) < 0)
		return fd;

	if(unlockpt(fd) < 0)
	{
		close(fd);
		return -1;
	}

	if(!(p = ptsname(fd)))
	{
		close(fd);
		return -1;
	}

	strcpy(ptys_name, p);
	return fd;
}	

fd_t	pty_open(char *pts_name)
{
	fd_t	fd;

	if((fd = open(pts_name, O_RDWR)) < 0)
		return -5;

	if(ioctl(fd, I_PUSH, "ptem") < 0)
	{
		close(fd);
		return -6;
	}

	if(ioctl(fd, I_PUSH, "ldterm") < 0)
	{
		close(fd);
		return -7;
	}

	if(ioctl(fd, I_PUSH, "ttcompat") < 0)
	{
		close(fd);
		return -8;
	}

	return fd;
}
#endif

#endif

