/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _lockfile.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/string.h>
#include <std/files.h>
#include <std/process.h>
#include <std/time.h>
#include <std/locking.h>
#include <std/errno.h>

#ifndef	_LOCK_FORMAT
#define	_LOCK_FORMAT	"%010d %s"
#endif

int	lockfile(const char *fpath, const char *option)
{
	int	fd;
	int	status;
	pid_t	pid;
	time_t	now;
	struct	stat	ino;
	int	len;
	int	mask;
	char	query[65];

	if(!option)
		option = "";

	for(;;)
	{
		fd = open(fpath, O_WRONLY | O_CREAT | O_EXCL, 0660);
		if(fd > 0)
		{
			pid = getpid();
			if(!strcmp(option, "disable"))
				pid = 1;
			sprintf(query, _LOCK_FORMAT, pid, option);
			write(fd, query, strlen(query));
			close(fd);
			return 0;
		}
		if(fd < 0 && errno != EEXIST)
			return -1;

		fd = open(fpath, O_RDONLY);
		if(fd < 0)
		{
			if(errno == ENOENT)
				continue;
			return -1;
		}
		sleep(2);
		status = read(fd, query, sizeof(query) - 1);
		if(status < 1)
		{
			close(fd);
			continue;
		}

		query[status] = 0;
		pid = atoi(query);
		if(pid)
		{
			if(pid == getpid())
			{
				status = -1;
				errno = 0;
			}
			else
				status = kill(pid, 0);
			if(!status || (errno == EPERM))
			{
				close(fd);
				return pid;
			}
		}	
		close(fd);			
		unlink(fpath);
	}
}
