/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _keydata.c 1.3 Thu, 30 Jul 1998 15:00:17 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/conf.h>
#include <std/string.h>
#include <std/ctype.h>
#include <std/keydata.h>

static	char	keypath[80] = "";
static	bool	opened = FALSE;
static	bool	found = FALSE;

static	int	loadkeydata(const char *id)
{
	if(!opened)
		return FALSE;

	if(!*id)
	{
		setconf();
		return (found = TRUE);
	}

	if(seekconf(id))
	{
		return (found = TRUE);
	}
	return (found = FALSE);
}

void	endkeydata(void)
{
	if(opened)
	{
		closeconf();
		opened = found = FALSE;
	}
}

int	getkeyset(const char *keyset)
{
	char	*id;
	bool	openit = FALSE;

	if(*keyset != '/' && *keyset != '~')
	{
		if(!opened)
			return FALSE;
	
		id = strrchr(keypath, '/');
		if(!id)
			return FALSE;

		++id;
		if(!strcmp(id, keyset))
			return found;

		strcpy(id, keyset);
		return loadkeydata(id); 	
	}
	if(!strcmp(keyset, keypath))
		return found;

	id = strrchr(keyset, '/');
	if(!id)
		return FALSE;

	if(strncmp(keyset, keypath, id - keyset))
		openit = TRUE;

	strcpy(keypath, keyset);
	id = strrchr(keypath, '/');
	if(openit)
	{
		*id = 0;
		endkeydata();
		if(!strncmp(keypath, "/etc/", 5))
			opened = ~openconf(keypath + 5);
		else
			opened = ~openconf(keypath);
		*(id++) = '/';
	} 	
	found = loadkeydata(id);
}

char	*dupkeydata(const char *keypath, const char *def)
{
	static	char	*page;
	static	int	left = 0;
	int	len;
	char	*id, *p;

	if(!found || !opened)
		return (char *)def;

	id = getconf(keypath);
	if(id)
	{
		len = strlen(id) + 1;
		if(len > 4096)
		{
			p = (char *)malloc(len);
			strcpy(p, id);
			id = p;
		}
		else
		{
			if(len > left)
			{
				left = 4096;
				page = (char *)malloc(4096);
			}
			strcpy(page, id);
			id = page;
			page += len;
			left -= len;
		}
	}
	else
		id = (char *)def;

	return id;
}

char	*getkeydata(const char *keypath, const char *def)
{
	char	*id = (char *)keypath;

	if(!found || !opened)
		return (char *)def;
	
	id = getconf(id);
	if(!id)
		id = (char *)def;

	return id;
}

long	getkeyvalue(const char *keypath, long def)
{
	char *p = getkeydata(keypath, NULL);

	if(p)
		return atol(p);
	else
		return def;
}

int	getkeyflag(const char *keypath, int flag)
{
	char *p = getkeydata(keypath, NULL);
	if(!p)
		return flag;

	switch(*p)
	{
	case 'y':
	case 'Y':
	case 't':
	case 'T':
	case '1':
		return TRUE;
	default:
		return FALSE;
	}
}
					
