/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _hostname.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef	GETHOSTNAME_F_MISSING
#include <std/process.h>

#ifdef	SYS_UTSNAME_H_MISSING
#include <std/files.h>
#include <std/paths.h>

int	gethostname(char *buf, size_t size)
{
	fd_t	fd;	
	int	len;	

	fd = open(_PATH_ETC "hostname", O_RDONLY);
	if(fd < 0)
		return -1;

	len = read(fd, buf, size - 1);
	if(len < 1)
		return -1;

	buf[len] = 0;
	return 0;
} 

#else
#include <sys/utsname.h>

int	gethostname(char *buf, size_t size)
{
	struct	utsname	ut;

	if(uname(&ut))
		return -1;

	strncpy(buf, ut.nodename, size - 1);
	buf[size] = 0;
	return 0;
}
#endif
#endif

