/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _fd.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/stream.h>
#include <std/sysid.h>

#ifdef	_CAP_PASSED_FILES

#ifdef	STROPTS_H_MISSING
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <errno.h>
#include <stddef.h>

fd_t	recvfd(fd_t str)
{
	struct	iovec	iov[1];
	struct	msghdr	msg;
	int	stat;

#ifdef	MSG_ACCRIGHTS_I_MISSING
	char	msgbuf[sizeof(struct cmsghdr) + sizeof(fd_t)];
	struct	cmsghdr *cmptr = (struct cmsghdr *)&msgbuf;
	char	*dptr = (char *)(cmptr) + sizeof(struct cmsghdr);
#else
	fd_t	fd;
#endif

	iov[0].iov_base = NULL;
	iov[0].iov_len = 0;
	msg.msg_iov = iov;
	msg.msg_iovlen = 1;
	msg.msg_name = NULL;
	msg.msg_namelen = 0;

#ifndef	MSG_ACCRIGHTS_I_MISSING
	msg.msg_accrights = (caddr_t)&fd;
	msg.msg_accrightslen = sizeof(fd_t);
#endif

	stat = recvmsg(str, &msg, 0);
	if(stat < 0)
		return stat;

#ifdef	MSG_ACCRIGHTS_I_MISSING
	return *((fd_t *)dptr);
#else
	return fd;
#endif
}

int	sendfd(fd_t str, fd_t fd)
{
	struct	iovec	iov[1];
 	struct	msghdr	msg;
	int	stat;

#ifdef	MSG_ACCRIGHTS_I_MISSING
	char	msgbuf[sizeof(struct cmsghdr) + sizeof(fd_t)];
	struct	cmsghdr *cmptr = (struct cmsghdr *)&msgbuf;
	char	*dptr = (char *)(cmptr) + sizeof(struct cmsghdr);
#endif
	iov[0].iov_base = NULL;
	iov[0].iov_len = 0;
	msg.msg_iov = iov;
	msg.msg_iovlen = 1;
	msg.msg_name = NULL;
	msg.msg_namelen = 0;

#ifdef	MSG_ACCRIGHTS_I_MISSING
	msg.msg_control = (caddr_t) cmptr;
	msg.msg_controllen = sizeof(msgbuf);
	cmptr->cmsg_level = SOL_SOCKET;
	cmptr->cmsg_type = SCM_RIGHTS;
	cmptr->cmsg_len = sizeof(msgbuf);
	memcpy(dptr, &fd, sizeof(fd_t));
#else
	msg.msg_accrights = (caddr_t) &fd;
	msg.msg_accrightslen = sizeof(fd);
#endif	
	stat = sendmsg(str, &msg, 0);
	if(stat < 0)
		return stat;
	
	return 0;
}

#else

int	sendfd(fd_t str, fd_t fd)
{
	int	ret = ioctl(str, I_SENDFD, fd);
	
	if(ret < 0)
		return ret;

	return 0;
}

fd_t	recvfd(fd_t str)
{
	struct	strrecvfd	rfd;
	int	ret = ioctl(str, I_RECVFD, &rfd);
	if(ret < 0)
		return ret;

	return (fd_t)rfd.fd;
}
	
#endif
#endif

