/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _confsym.c 1.3 Sat, 10 Oct 1998 11:58:45 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/conf.h>
#include <std/string.h>
#include <std/ctype.h>

#ifndef KEYSIZE
#define KEYSIZE 97
#endif

#ifndef MAXLINE
#define MAXLINE 1024
#endif

typedef struct	_sym
{
        struct	_sym     *next;
        char    *value;
        char    key[ __EMPTY__ ];
}	sym;

static  sym     **idx;

static  unsigned keynum(const char *str)
{
        unsigned        base = 0;

        while(*str)
        {
                base = base << 1;
                base ^= *str;
		++str;
        }
        return base % KEYSIZE;
}

static  sym     *loadconf(const char *key)
{
        int     count;
        char    lbuf[MAXLINE];
        char    *cf;
        sym     *var;
        int     path;

        idx = (sym **)_memconf(0);
        if(idx)
                return idx[keynum(key)];

        idx = (sym **)_memconf(sizeof(sym *) * KEYSIZE);
        count = KEYSIZE;
        while(count--)
                idx[count] = NULL;

        while(NULL != (cf = readconf(lbuf, -MAXLINE)))
        {
                var = (sym *)_memconf(sizeof(sym) + strlen(lbuf) + 1);
                if(!var)
                        break;

                strcpy(var->key, cf);
                cf = strchr(var->key, '=');
                if(cf)
                {
                        *cf = 0;
                        var->value = ++cf;
                        /* var->max = strlen(cf); */
                }
                else
                        var->value = "";
                
                path = keynum(var->key);
                var->next = idx[path];
                idx[path] = var;
        }
        return idx[keynum(key)];
}

void	*dupconf(void)
{
	sym	**idx1 = idx;
	idx = NULL;
	getconf("*");
	_dupconf();
	setconf();
	return (void *)idx1;
}

static	char	*_getconf(sym *var, const char *key)
{
	char	*k, *v;

        while(var)
        {
                k = (char *)key;
                v = var->key;
                while(*k)
                {
                        if(isspace(*k))
                        {
                                ++k;
                                continue;
                        }
                        if(tolower(*k) != *v)
                                break;
                        ++k;
                        ++v;
                }
                if(*k == *v)
                        return var->value;

                var = var->next;
        }
        return NULL;
}

char	*getconf(const char *key)
{
	return _getconf(loadconf(key), key);
}

char	*getconf2(void *i, const char *key)
{
	sym	**idx = (sym **)i;

	if(!idx)
		return NULL;

	return _getconf(idx[keynum(key)], key);
}

