/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _confmem.c 1.2 Sat, 22 Aug 1998 19:06:39 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/conf.h>
#include <std/string.h>

#ifndef	PAGELIMIT
#define	PAGELIMIT	8192
#endif

typedef struct	_page
{
        struct	_page   *next;
        unsigned        used;
        char            buf [ __EMPTY__ ];
}       page;

static	page    *root = NULL;
static	int	pagesize = 0;

void	_dupconf(void)
{
	root = NULL;
}

void    _freeconf(void)
{
        page    *next;

        while(root)
        {
                next = root->next;
                free(root);
                root = next;
        }
}

void    *_memconf(size_t size)
{
        page    *next = root;
        char    *mem;

        if(!size)
        {
                if(root)
                        return root->buf;
                return NULL;
        }

	while(pagesize < PAGELIMIT)	/* find logical size */
		pagesize += getpagesize();

        if(size > pagesize - sizeof(page))
                return NULL;

        while(next)
        {
                if(next->used >= size)
                {
                        mem = &next->buf[next->used];
                        next->used += size;
                        return mem;
                }
                next = next->next;
        }
        next = (page *)malloc(pagesize);
        if(!next)
                return NULL;

        next->used = size;
        next->next = root;
        root = next;
        return next->buf;
}


