/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _confio.c 1.2 Sun, 06 Sep 1998 20:00:30 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/files.h>
#include <std/conf.h>
#include <std/string.h>
#include <std/ctype.h>
#include <std/paths.h>
#include <std/limits.h>

#ifndef BUFSIZE
#define BUFSIZE 1024
#endif

#ifndef NAMESIZE
#define NAMESIZE        128
#endif

#ifndef SUFFIX
#define SUFFIX  ".conf"
#define BACKUP  ".save"
#endif

#ifndef PREFIX
#define PREFIX  _PATH_ETC
#endif

static  char    *buf = NULL;
static  int     bpos = 0;
static  int     len = 0;
static  fd_t    fd = -1;
static  char    name[NAMESIZE];

void    closeconf(void)
{
        if(fd > -1)
                close(fd);

        if(buf)
        {
                free(buf);
                buf = NULL;
        }

        _freeconf();
        fd = -1;
        bpos = 0;
        len = 0;
}

int     openconf(const char *path)
{
        static  char    *cpath = NULL;
        static  int     pathmax;
        char    *ext;
        char    *fn;
        int     filemax;
        char    *home;
        int     len;

        closeconf();

        if(*path == '~')
        {
                home = getenv("HOME");
                if(!home)
                        home = _PATH_TMP;
		
		pathmax = limit_pathmax(512, home);
		buf = (char *)malloc(pathmax + BUFSIZE);
		cpath = buf + BUFSIZE;
                strncpy(cpath, home, pathmax - strlen(path) - 2);
                cpath[pathmax - strlen(path) - 2] = 0;
                strcat(cpath, "/.");
                strcat(cpath, path + 1);
                fn = strrchr(cpath, '/');
		++fn;
        }
        else
        {
                if(*path == '/')
                {
                        pathmax = limit_pathmax(512, path);
                        buf = (char *)malloc(pathmax + BUFSIZE);
                        cpath = buf + BUFSIZE;
                        strncpy(cpath, path, pathmax - 8);
                        cpath[pathmax - 8] = 0;
                }
                else
                {
			pathmax = limit_pathmax(512, PREFIX);
                	buf = (char *)malloc(pathmax + BUFSIZE);
                	cpath = buf + BUFSIZE;
                        strcpy(cpath, PREFIX);
                        strncat(cpath, path, pathmax - 8);
                        cpath[pathmax - 8 - strlen(PREFIX)] = 0;
                }
                fn = strrchr(cpath, '/');
                *fn = 0; 
                filemax = pathconf(cpath, _PC_NAME_MAX);
                *(fn++) = '/';
                len = strlen(fn);
                if(len + strlen(SUFFIX) > filemax)
                        len = filemax - strlen(SUFFIX);
                ext = fn + len;
                strcpy(ext, SUFFIX);
        }
        fd = open(cpath, O_RDONLY);
        if(fd < 0)
        {
                if(*path == '~')
                        *fn = '~';
                else
                        strcpy(ext, BACKUP);
                fd = open(cpath, O_RDONLY);
        }
        if(fd < 0)
        {
                free(buf);
                buf = NULL;
        }
	if(fd < 0)
	        return fd;
	else
	{
		fcntl(fd, F_SETFD, 1l);
		return 0;
	}
}

char    *readconf(char *str, int max)
{
        int     nl = 0;
        int     eq = 1;
        char    *ret = str;
        char    *mp = NULL;
        char    *ep = NULL;
        char    qflag = 0;                    

        if(fd < 0 || !buf)
                return NULL;

        if(max < 0)
        {
                max = -max;
                eq = 0;
        }

        for(;;)
        {
                if(bpos >= len)
                {
                        bpos = 0;
                        len = read(fd, buf, BUFSIZE);
                        if(len < 1)
                                return NULL;
                }

                while(nl && bpos < len)
                {
                        if(buf[bpos++] == '\n')
                        {
                                nl = 0;
                                break;
                        }
                }

                while(bpos < len && isspace(buf[bpos]))
                        ++bpos;

                if(bpos >= len)
                        continue;

                if(buf[bpos] == '[')
                        return NULL;

                if(!nl && buf[bpos] == '#')
		{
			++bpos;
                        ++nl;
			continue;
		}
		break;
        }	

        while(--max)
        {
                if(buf[bpos] == '\n' && qflag != '}')
                {
                        if(mp)
                        {
                                str = mp;
                                mp = NULL;
                                ++bpos;
                        }
                        else
                                break;
                }
                else
                {
                        if(mp)
                                if(!isspace(buf[bpos]))
                                        mp = NULL;

                        if(buf[bpos] == '\\' && qflag != '}')
                                mp = str;

                        switch(eq)
                        {
                        case 0:
                                if(isspace(buf[bpos]))
                                {
                                        ++bpos;
                                        break;
                                }
                                if(buf[bpos] == '=')
                                        ++eq;
                                *(str++) = tolower(buf[bpos++]);
                                break;
                        case 1:
                                if(isspace(buf[bpos]))
                                {
                                        ++bpos;
                                        break;
                                }
                                else
                                        ++eq;
                                if(buf[bpos] == '\'' || buf[bpos] == '\"')
                                {
                                        qflag = buf[bpos++];
                                        break;
                                }
                                if(buf[bpos] == '{')
                                {
                                        qflag = '}';
                                        ++bpos;
                                        break;
                                }
                        case 2:
                                if(buf[bpos] == qflag)
                                {
                                        ep = str;
                                        qflag = 0;
                                }
                                *(str++) = buf[bpos++];
                        }
                }

                if(bpos >= len)
                {
                        bpos = 0;
                        len = read(fd, buf, BUFSIZE);
                        if(len < 1)
                                return NULL;
                }
        }
        *str = 0;
        if(ep)
                *ep = 0;
        else
                while(isspace(*(--str)))
                        *str = 0;

        return ret;
}

void	setconf(void)
{
	if(fd < 0 || !buf)
		return;

	_freeconf();
	lseek(fd, 0l, SEEK_SET);
	bpos = len = 0;
}

char    *seekconf(const char *str)
{
        register        char ch;

        int     mflag = 0;
        int     mpos = 0;

        enum
        {
                S_NL,
                S_LEAD,
                S_MATCH
        }       state = S_LEAD;

        if(fd < 0 || !buf)
                return NULL;

        if(str)
        {
                lseek(fd, 0l, SEEK_SET);
                bpos = 0;
                len = 0;
        }

	_freeconf();
        for(;;)
        {
                if(bpos >= len)
                {
                        bpos = 0;
                        len = read(fd, buf, BUFSIZE);
                        if(len < 1)
                                return NULL;
                }
                switch(state)
                {
                case S_LEAD:
                        while(bpos < len)
                        {
                                ch = buf[bpos++];
                                if(!isspace(ch))
                                {
                                        mpos = 0;
                                        if(ch == '[')
                                                state = S_MATCH;
                                        else
                                                state = S_NL;
                                        break;
                                }
                        }
                        break;
                case S_NL:
                        while(bpos < len)
                        {
                                if(buf[bpos++] == '\n')
                                {
                                        if(mflag)
                                        {
                                                if(mpos >= NAMESIZE)
                                                        mpos = NAMESIZE - 1;

                                                name[mpos] = 0;
                                                return name;
                                        }
                                       
                                        state = S_LEAD;
                                        break;
                                }
                        }
                        break;
                case S_MATCH:
                        while(bpos < len)
                        {
                                ch = buf[bpos++];
                                if(ch == ']')
                                {
                                        if(str)
                                        {
                                                if(!str[mpos])
                                                        ++mflag;
                                        }
                                                else
                                                        ++mflag;
                                        state = S_NL;
                                        break;
                                }
                                if(mpos < NAMESIZE - 1)
                                        name[mpos] = ch;

                                if(str)
                                {
                                        if(toupper(ch) != toupper(str[mpos++]))
                                        {
                                                state = S_NL;
                                                break;
                                        }
                                }
                                else
                                        ++mpos;
                        }
                }         
        }                
}


