/* Portable System Interfaces Copyright (c) 1997-1998 Tycho Softworks.
 * $Id: _conf.c 1.1 Tue, 23 Jun 1998 11:38:33 -0400 dyfet $
 *
 * Permission is hear-by granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute with modifications, sub-license, and/or sell copies of the
 * software, and to permit persons to whom the Software is furnished to
 * do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * Neither the name of Tycho Softworks nor the names of it's contributors
 * may be used to endorse or promote products derived from this Software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY TYCHO SOFTWORKS "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL TYCHO SOFTWORKS OR IT'S
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * OR CONSEQUENTIAL DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS "SOFTWARE",
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <std/process.h>
#include <std/files.h>

#ifdef	PATHCONF_F_MISSING

#ifndef	LINK_MAX
#define	LINK_MAX	_POSIX_LINK_MAX;
#endif

#ifndef	MAX_CANON
#define	MAX_CANON	_POSIX_MAX_CANON
#endif

#ifndef	MAX_INPUT
#define	MAX_INPUT	_POSIX_MAX_INPUT
#endif

#ifndef	NAME_MAX
#define	NAME_MAX	_POSIX_NAME_MAX
#endif

#ifndef	PATH_MAX
#define	PATH_MAX	_POSIX_PATH_MAX
#endif

#ifndef	PIPE_BUF
#define	PIPE_BUF	_POSIX_PIPE_BUF
#endif

#ifndef	CHOWN_RESTRICTED
#ifdef	_POSIX_CHOWN_RESTRICTED
#define	CHOWN_RESTRICTED
#endif
#endif

#ifndef	NO_TRUNC
#ifdef	_POSIX_NO_TRUNC
#define	NO_TRUNC
#endif
#endif

#ifndef	VDISABLE
#ifdef	_POSIX_VDISABLE
#define	VDISABLE
#endif
#endif

long	pathconf(char *path, int pc)
{
	switch(pc)
	{
	case _PC_LINK_MAX:
		return LINK_MAX;
	case _PC_MAX_CANON:
		return MAX_CANON;	
	case _PC_MAX_INPUT:
		return MAX_INPUT;
	case _PC_NAME_MAX:
		return NAME_MAX;
	case _PC_PATH_MAX:
		return PATH_MAX;
	case _PC_PIPE_BUF:
		return PIPE_BUF;
	case _PC_CHOWN_RESTRICTED:
#ifdef	CHOWN_RESTRICTED
		return 1;
#else
		return 0;
#endif
	case _PC_NO_TRUNC:
#ifdef	NO_TRUNC
		return 1;
#else
		return 0;
#endif
	case _PC_VDISABLE:
#ifdef	VDISABLE
		return 1;
#else
		return 0;
#endif
	}
	return -1;
}

long	fpathconf(int fd, int pc)
{
	return pathconf("/", pc);
}
#endif

#ifdef	SYSCONF_F_MISSING

#ifndef	ARG_MAX
#define	ARG_MAX	_POSIX_ARG_MAX
#endif

#ifndef	CHILD_MAX
#define	CHILD_MAX _POSIX_CHILD_MAX
#endif

#ifndef	CLK_TCK
#define	CLK_TCK	18
#endif

#ifndef	STREAM_MAX
#define	STREAM_MAX _POSIX_STREAM_MAX
#endif

#ifndef TZNAME_MAX
#define	TZNAME_MAX _POSIX_TZNAME_MAX
#endif

#ifndef	OPEN_MAX
#define	OPEN_MAX _POSIX_OPEN_MAX
#endif

#ifndef	NGROUPS_MAX
#define	NGROUPS_MAX _POSIX_NGROUPS_MAX
#endif

#ifndef	JOB_CONTROL
#ifdef	_POSIX_JOB_CONTROL
#define	JOB_CONTROL
#endif
#endif

#ifndef	SAVED_IDS
#ifdef	_POSIX_SAVED_IDS
#define	SAVED_IDS
#endif
#endif

long	sysconf(int name)
{
	switch(name)
	{
	case _SC_ARG_MAX:
		return ARG_MAX;
	case _SC_CHILD_MAX:
		return CHILD_MAX;
	case _SC_CLK_TCK:
		return CLK_TCK;
	case _SC_STREAM_MAX:
		return STREAM_MAX;
	case _SC_TZNAME_MAX:
		return TZNAME_MAX;
	case _SC_OPEN_MAX:
		return OPEN_MAX;
	case _SC_NGROUPS_MAX:
		return NGROUPS_MAX;
	case _SC_JOB_CONTROL:
#ifdef	JOB_CONTROL
		return 1;
#else
		return 0;
#endif
	case _SC_SAVED_IDS:
#ifdef	SAVED_IDS
		return 1;
#else
		return 0
#endif
	}
	return -1;
}

#endif
