# Portable System Interface Copyright (c) 1997-1998 Tycho Softworks
# $Id: install.make 1.6 Mon, 23 Nov 1998 09:58:53 -0500 dyfet $

case "$CONFIG_ARCH" in
*-cygwin32)
	if test -z "$CONFIG_PREFIX" ; then
        	CONFIG_PREFIX=$CYGFS
	fi
	if test -z "$CONFIG_EPREFIX" ; then
	        CONFIG_EPREFIX=`echo $CYGFS/*cygwin32`
        	CONFIG_CONFDIR=$CONFIG_EPREFIX/etc
        	CONFIG_SLIBDIR=$CONFIG_EPREFIX/bin
		CONFIG_SBINDIR=$CONFIG_SLIBDIR
        	CONFIG_LIBDIR=$CONFIG_EPREFIX/lib
        	CONFIG_LIBEXEC=$CONFIG_EPREFIX/libexec
	fi
	;;
esac

if test ! -z "$CONFIG_PREFIX" ; then
	UPREFIX=$CONFIG_PREFIX
else
	UPREFIX=$CONFIG_HOST
fi

if test ! -z "$CONFIG_EPREFIX" ; then
	EPREFIX=$CONFIG_EPREFIX
else
	EPREFIX=$CONFIG_HOST
fi

echo "root="$CONFIG_ROOT >config.install
echo 'prefix=$(root)'$UPREFIX >>config.install
echo 'eprefix=$(root)'$EPREFIX >>config.install

if test -z "$CONFIG_SHARE" ; then
	if test -d $UPREFIX/share ; then
		echo 'share=$(prefix)/share' >>config.install
	else
		echo 'share=$(prefix)' >>config.install
	fi
else
	echo 'share=$(root)'$CONFIG_SHARE >>config.install
fi
	

if test -z "$CONFIG_CONFDIR" ; then
	echo 'SYSCONFDIR=$(root)/etc' >>config.install
else
	echo 'SYSCONFDIR=$(root)'$CONFIG_CONFDIR >>config.install
fi

if test -z "$CONFIG_BINDIR" ; then
	echo 'BINDIR=$(eprefix)/bin' >>config.install
else
	echo 'BINDIR=$(root)'$CONFIG_BINDIR >>config.install
fi

if test -z "$CONFIG_SBINDIR" ; then
	if test -d $EPREFIX/sbin ; then
		echo 'SBINDIR=$(eprefix)/sbin' >>config.install
	else
		echo 'SBINDIR=$(root)/etc' >>config.install
	fi
else
	echo 'SBINDIR=$(root)'$CONFIG_SBINDIR >>config.install
fi

if test -z "$CONFIG_INCDIR" ; then
	echo 'INCDIR=$(prefix)/include' >>config.install
else
	echo 'INCDIR=$(root)'$(CONFIG_INCDIR) >>config.install
fi

if test -z "$CONFIG_LIBDIR" ; then
	echo 'LIBDIR=$(eprefix)/lib' >>config.install
else
	echo 'LIBDIR=$(root)'$CONFIG_LIBDIR >>config.install
fi

if test -z "$CONFIG_SLIBDIR" ; then
	echo 'SLIBDIR=$(root)/lib' >>config.install
else
	echo 'SLIBDIR=$(root)'$CONFIG_SLIBDIR >>config.install
fi

if test -z "$CONFIG_LIBEXEC" ; then
	if test -d $UPREFIX/share/libexec ; then
		echo 'LIBEXEC=$(share)/libexec' >>config.install
	elif test -z "$CONFIG_LIBEXEC" ; then
		if test -d $UPREFIX/sbin ; then
			echo 'LIBEXEC=$(prefix)/sbin' >>config.install
		fi
	else
		echo 'LIBEXEC=$(prefix)/lib/'$LIBEXEC >>config.install
	fi
else
	echo 'LIBEXEC=$(root)/'$CONFIG_LIBEXEC'/' >>config.install
fi

if test -z "$CONFIG_MANDIR" ; then
	if test -d $UPREFIX/share/man ; then
		if test -d $CONFIG_PREFIX/man ; then
			echo 'MANDIR=$(prefix)/man' >>config.install
		else
			echo 'MANDIR=$(share)/man' >>config.install
		fi
	else
		echo 'MANDIR=$(prefix)/man' >>config.install
	fi
else
	echo 'MANDIR=$(root)'$CONFIG_MANDIR >>config.install
fi

if test -z "$CONFIG_INFODIR" ; then
	if test -d $UPREFIX/share/info ; then
		if test -d $CONFIG_PREFIX/info ; then
			echo 'INFODIR=$(prefix)/info' >>config.install
		else
			echo 'INFODIR=$(share)/info' >>config.install
		fi
	else
		echo 'INFODIR=$(prefix)/info' >>config.install
	fi
else
	echo 'INFODIR=$(root)'$CONFIG_INFODIR >>config.install
fi

if test -z "$CONFIG_HTMLDIR" ; then
	if test -d $UPREFIX/share/html ; then
		echo 'HTMLDIR=$(share)/html' >>config.install
	else
		if test -d "/home/httpd" ; then
			echo 'HTMLDIR=/home/httpd/html' >>config.install
		else
			echo 'HTMLDIR=$(prefix)/html' >>config.install
		fi
	fi
else
	echo 'HTMLDIR=$(root)'$CONFIG_HTMLDIR >>config.install
fi

if test -z "$CONFIG_DISTDIR" ; then
	if test -d $UPREFIX/share/dist ; then
		echo 'DISTDIR=$(share)/dist' >>config.install
	else
		if test -d /home/ftp ; then
			echo 'DISTDIR=/home/ftp' >>config.install
		else
			echo 'DISTDIR=$(prefix)/dist' >>config.install
		fi
	fi
else
	echo 'DISTDIR=$(root)'$CONFIG_DISTDIR >>config.install
fi

if test -z "$inc" ; then
	inc=$CONFIG_HOST/include
fi

if test -z "$CONFIG_ELF" ; then
	if test ! "$Cinc/*elf.h" = $inc/'*elf.h' ; then
		CONFIG_ELF='true'
	fi
	if test ! -z "$CONFIG_HOST/lib/*.so" ; then
		CONFIG_ELF='true'
	fi
fi

if test "$CONFIG_ELF" = "true" ; then
	echo 'SHARED=shared' >>config.install
	echo 'LIBTARGET=shared' >>config.install
else
	echo 'LIBTARGET=static' >>config.install
fi

if test ! -z "$CONFIG_TARGET" ; then
	echo 'TARGET='$CONFIG_TARGET >>config.install
else
	echo 'TARGET=normal' >>config.install
fi

echo "CONFIG_ROOT="$CONFIG_ROOT >>config.cache
echo "CONFIG_TARGET="$CONFIG_TARGET >>config.cache
echo "CONFIG_PREFIX="$CONFIG_PREFIX >>config.cache
echo "CONFIG_EPREFIX="$CONFIG_EPREFIX >>config.cache
echo "CONFIG_SHARE="$CONFIG_SHARE >>config.cache
echo "CONFIG_CONFDIR="$CONFIG_CONFDIR >>config.cache
echo "CONFIG_BINDIR="$CONFIG_BINDIR >>config.cache
echo "CONFIG_LIBEXEC="$CONFIG_LIBEXEC >>config.cache
echo "CONFIG_SBINDIR="$CONFIG_SBINDIR >>config.cache
echo "CONFIG_LIBDIR="$CONFIG_LIBDIR >>config.cache
echo "CONFIG_SLIBDIR="$CONFIG_SLIBDIR >>config.cache
echo "CONFIG_INFODIR="$CONFIG_INFODIR >>config.cache
echo "CONFIG_MANDIR="$CONFIG_MANDIR >>config.cache
echo "CONFIG_HTMLDIR="$CONFIG_HTMLDIR >>config.cache
echo "CONFIG_DISTDIR="$CONFIG_DISTDIR >>config.cache
