if test ! -z "$DATABASES" ; then
	for database in $DATABASES ; do
		if test ! -z "$DATABASE" ; then
			break
		fi
		case $database in
		postgres)
			if test -f $CONFIG_HOST/lib/libpq.a ; then
				DATABASE="-DPOSTGRES -I$inc/pgsql"
				LIBDBMS='-lpq'
			fi
			;;
		mysql)
			if test -d $CONFIG_HOST/lib/mysql ; then
				DATABASE="-DMYSQL -I$inc/mysql"
				LIBDBMS="-L$CONFIG_HOST/lib/mysql -lmysqlclient'
			fi
			if test -f $CONFIG_HOST/lib/libmysqlclient.a ; then
				DATABASE="-DMYSQL -I$inc/mysql"
				LIBDBMS='-lmysqlclient'
			endif
		dbm)
			;;
		esac
	done
fi

if test ! -z "$DATABASE" ; then
	echo "DATABASE=$DATABASE" >>config.make
	echo "LIBDBMS=$LIBDBMS" >>config.make
fi

