/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: transfer.c 1.2 Mon, 26 Oct 1998 00:32:12 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include "dbs.h"

int	dbs_transfer_extension(int slot, int target, int source)
{
	DBSMSG	msg[DBS_TRANSFER_MSGLEN];

	msg[11] = 0;
	dbs_setslot(msg, slot);	
	dbs_setmsglen(msg, sizeof(msg));
	dbs_setmsgtype(msg, DBS_TRANSFER_MSGTYPE);
	dbs_setextension((DBSNBR *)&msg[6], source);
	dbs_setextension((DBSNBR *)&msg[12], target);
	return dbs_send(msg);
}

int	dbs_transfer_trunk(int slot, int ext, int trunk)
{
	DBSMSG	msg[DBS_TRANSFER_MSGLEN];
	
	msg[11] = 0;
	dbs_setslot(msg, slot);
	dbs_setmsglen(msg, sizeof(msg));
	dbs_setmsgtype(msg, DBS_TRANSFER_MSGTYPE);
	dbs_settrunk((DBSNBR *)&msg[6], trunk);
	dbs_setextension((DBSNBR *)&msg[12], ext);
	return dbs_send(msg);
}
