/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: syslog.c 1.1 Sat, 19 Sep 1998 20:57:22 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include "dbs.h"

int	dts_syslog(int slot, int log_level, char *logmsg)
{
	DBSMSG	msg[128];

	if(slot > -1)
		dbs_setslot(msg, slot);	
	else
		msg[2] = msg[3] = 0xff;

	dbs_setmsglen(msg, 16 + strlen(logmsg) + 1);
	dbs_setmsgtype(msg, log_level);
	msg[0] = 1;
	dbs_getappname(msg + 6, 10);
	strcpy(msg + 16, logmsg);
	return dbs_send(msg);
}

