/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: slots.c 1.2 Mon, 26 Oct 1998 00:32:12 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/files.h>
#include <std/conf.h>
#include <std/limits.h>
#include <std/string.h>
#include <std/socket.h>
#include <std/stream.h>
#include <std/errno.h>
#include "dbs.h"

#define	MAX_SLOTS	8

static	uchar	slot[MAX_SLOTS];
static	int	slots = 0;
static	char	*apid[] = {"???", "acd", "aa", "vm", "???"};

int	dbs_getslots(void)
{
	return slots;
}

void	dbs_setslots(char *msg)
{
	char	*p, *q;
	uchar	apid;
	slots = 0;

	strlwr(msg);
	p = strtok(msg, " \t\n;:");
	while(p && slots < MAX_SLOTS)
	{
		q = NULL;
		if(!strncmp(p, "acd", 3))
		{
			apid = APID_ACD;
			q = p + 3;
		}
		if(!strncmp(p, "vm", 2))
		{
			apid = APID_VM;
			q = p + 2;
		}
		if(!strncmp(p, "aa", 2))
		{
			apid = APID_AA;
			q = p + 2;
		}
		p = strtok(NULL, " \t\n;:");
		if(!q)
			continue;
		slot[slots++] = apid * 16 | (*q & 0x0f);
	}
}

int	dbs_getslot(DBSMSG *msg)
{
	uchar	id = dbs_getapid(msg) * 16 + dbs_getvtid(msg);
	int	i = 0;

	while(i < slots)
	{
		if(id == slot[i])
			return i;

		++i;
	}
	return -1;
}

void	dbs_setslot(DBSMSG *msg, int sl)
{
	if(sl < 0 || sl >= slots)
		return;

	dbs_setapid(msg, slot[sl] / 16);
	dbs_setvtid(msg, slot[sl] & 0x0f);
}

char	*dbs_getslotid(int sl)
{
	static	char	buf[5];
	int	len;

	if(sl < 0 || sl >= slots)
		return NULL;

	strcpy(buf, apid[slot[sl] / 16]);
	len = strlen(buf);

	buf[len++] = '0' + (slot[sl] & 0x0f);	
	buf[len] = 0;
	return buf;
}
