/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: iosub.c 1.3 Thu, 22 Oct 1998 20:58:25 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/files.h>
#include <std/conf.h>
#include <std/limits.h>
#include <std/string.h>
#include <std/socket.h>
#include <std/stream.h>
#include <std/errno.h>
#include "dbs.h"

#define	MAXAPID		3
#define	MAXVTID		8
#define	SIGSUM_SIZE	17

typedef	struct
{
	ulong send, recv;
	bool	activate;
}	CHANNEL;

static	CHANNEL	channels[4][8];
static	SOCKET	dbs = -1;
static	void	*cfg = NULL;
static	char	*myappname = "user";

char	*_dbs_password;
int	dbs_stations = 32, dbs_trunks = 16, dbs_digits = 3;

static	uchar	dbs_sum(uchar *msg, int len)
{
	uchar	sum = 0;
	while(len--)
		sum ^= *(msg++);
	
	return sum;
}

int	dbs_send(DBSMSG *msg)
{
	unsigned char	tail[5];
	int	len = dbs_getmsglen(msg);	
	struct	iovec	iov[2];
	CHANNEL	*ch;
	unsigned long seq;

	if(msg[2] < MAXAPID && msg[3] < MAXVTID)
		ch = &channels[msg[2]][msg[3]];
	else
		ch = NULL;

	if(ch)
		seq = htonl(ch->send);
	else
		seq = 0;

	tail[0] = dbs_sum(msg, len);
	memcpy(tail + 1, &seq, 4);
	iov[0].iov_base = msg;
	iov[0].iov_len = len;
	iov[1].iov_base = tail;
	iov[1].iov_len = 5;	
	if(writev(dbs, iov, 2) != len + 5)
		return -1;
	if(ch)
		++ch->send;
	return 0;
}

int	dbs_recv(DBSMSG *msg)
{
        unsigned char   tail[5], verify[5];
        int     len, ret;
        struct  iovec   iov[2];
	CHANNEL	*ch;
	unsigned long seq;

	ret = recv(dbs, msg, 6, MSG_PEEK);
	if(ret < 6)
		return -1;

	len = dbs_getmsglen(msg);

        iov[0].iov_base = msg;
        iov[0].iov_len = len;
        iov[1].iov_base = verify;
        iov[1].iov_len = 5;

        ret = readv(dbs, iov, 2);
	if(ret != len + 5)
		return -1;

        if(msg[2] < MAXAPID && msg[3] < MAXVTID)
                ch = &channels[msg[2]][msg[3]];
        else
                ch = NULL;

	if(ch)
		seq = htonl(ch->recv++);
	else
		seq = 0;
		
        memcpy(tail + 1, &seq, 4);
	tail[0] = dbs_sum((uchar *)msg, len);
	if(memcmp(tail, verify, 5))
		return -1;

	return 0; 
} 

int	dbs_shutdown(void)
{
	if(dbs > -1)
	{
		endsocket(dbs);
		return 0;
	}
	return -1;
}

int	dbs_connect(char *appname)
{
	struct	servent	*svc;
	char	*p;
	short	port;
	int	i;

	if(dbs != -1)
	{
		errno = EBUSY;
		return -2;
	}

	memset(channels, 0, sizeof(channels));
	if(openconf("dbs"))
	{
		errno = EACCES;
		return -1;
	}

	seekconf("common");

	p = getconf("port");
	if(!p)
	{
		svc = getservbyname("papi", "udp");
		if(!svc)
			return -1;

		port = ntohs(svc->s_port);
	}
	else
		port = atoi(p);

	p = getconf("size");
	if(p)
		i = atoi(p);
	else
		i = 0;

	switch(i)
	{
	case 40:
	case 832:
		dbs_stations = 32;
		dbs_trunks = 16;
		break;
	case 72:
		dbs_stations = 64;
		dbs_trunks = 32;
		break;
	}

	p = getconf("stations");
	if(p)
		dbs_stations = atoi(p);

	p = getconf("trunks");
	if(p)
		dbs_trunks = atoi(p);

	p = getconf("digits");
	if(p)
		dbs_digits = atoi(p);

	p = getconf("password");
	if(p)
		_dbs_password = strdup(p);
	else
		_dbs_password = "9999";

	p = getconf("host");
	if(!p)
		p = "127.0.0.1";

	dbs = getsocket(p, port, SOCK_DGRAM);
	if(dbs == INVALID_SOCKET)
		return -1;

	cfg = NULL;
	if(appname)
	{
		myappname = appname;
		p = getconf(appname);
		if(p)
			dbs_setslots(p);

		if(seekconf(appname))
			cfg = dupconf();
	}	
	closeconf();
	return 0;
}

void	dbs_getappname(char *id, int len)
{
	char	*p = myappname;
	while(len--)
	{
		if(*p && len > 1)
			*(id++) = *(p++);
		else
			*(id++) = 0;
	}
}

char	*dbs_getstring(char *str, char *def)
{
	char *p = getconf2(cfg, str);
	if(!p)
		return def;

	return p;
}

long	dbs_getvalue(char *id, long def)
{
	char	*p = getconf2(cfg, id);
	if(!p)
		return def;

	return atol(p);
}

