/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: extnbr.c 1.3 Mon, 26 Oct 1998 00:32:12 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include "dbs.h"

short 	dbs_getextension(DBSNBR *nbr)
{
	if(nbr->nbrtype)
		return -1;
	
	if((nbr->digits != 1) && (nbr->digits != dbs_digits))
		return -1;

	 return dbs_getextnbr(nbr->nbr);
}		

void	dbs_setnumber(DBSNBR *nbr, int num, int type)
{
	nbr->nbrtype = type;
	nbr->digits = 3;
	if(num < 10)
		nbr->digits = 1;
	if(num < 100)
		nbr->digits = 2;	

	dbs_setbcd(nbr->nbr, num, 6);
}

void	dbs_settrunk(DBSNBR *nbr, int num)
{
	nbr->nbrtype = 1;
	nbr->nbr[1] = nbr->nbr[2] = 0xff;
	nbr->digits = 2;
	nbr->nbr[0] = ((num / 10) * 16) + (num % 10);
	return;
}

void 	dbs_setextension(DBSNBR *nbr, int num)
{
	nbr->nbrtype = 0;
	
	nbr->nbr[1] = nbr->nbr[2] = 0xff;

	if(num < 10)
	{
		nbr->digits = 1;
		nbr->nbr[0] = (num * 16) | 0x0f;
		return;
	}

	nbr->digits = 2;
	if(num > 99)
	{
		++nbr->digits;
		nbr->nbr[1] = ((num % 10) * 16) | 0x0f;
		num /= 10;
	}
	nbr->nbr[0] = ((num / 10) * 16) + (num % 10);
	return;
}

short 	dbs_getextnbr(DBSMSG *msg)
{
	int nbr;

	if(msg[2] != 0xff)
		return -1;

	nbr = (msg[0] / 16) * 10 + (msg[0] % 16);
	if(nbr > 99 || (msg[0] % 16) > 9)
		return -1;

	if(msg[1] == 0xff)
		return nbr;

	if(msg[1] & 0x0f != 0x0f || (msg[1] / 16) > 10)
		return -1;

	return (nbr * 10) + (msg[1] / 16);
}

