/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: display.c 1.2 Sun, 11 Oct 1998 20:20:08 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include "dbs.h"

int	dbs_display(int slot, int extension, int line, char *text, int mode)
{
	DBSMSG	msg[DBS_DISPLAY_MSGLEN];
	int	digits;
	char	*tp = msg + 14;

	if(!text)
		text = "";

	digits = strlen(text);
	if(digits > 16)
		digits = 16;

	dbs_setslot(msg, slot);	
	dbs_setmsglen(msg, sizeof(msg));
	dbs_setmsgtype(msg, DBS_DISPLAY_MSGTYPE);
	dbs_setextension((DBSNBR *)&msg[6], extension);
	msg[12] = line % 7;
	msg[11] = mode % 3;	

	if(msg[12] == 1)
	{
		++tp;
		if(digits == 16)
			--digits;
	}

	msg[13] = digits;
	memset(msg + 14, 0, 16);
	while(digits--)
		*(tp++) = *(text++);

	return dbs_send(msg);
}

int	dbs_display_line(int slot, int extension, int line, char *text)
{
	return dbs_display(slot, extension, line, text, DBS_DISPLAY_UPDATE);
}

int	dbs_clear_line(int slot, int extension, int line)
{
	return dbs_display(slot, extension, line, NULL, DBS_DISPLAY_CLEAR);
}

int	dbs_display_clear(int slot, int extension)
{
	int i;
	for(i = 0; i < 7; ++i)
		dbs_clear_line(slot, extension, i);
}

int	dbs_display_menu(int slot, int extension)
{
	return dbs_display(slot, extension, 2, NULL, DBS_DISPLAY_MENU);
}

