/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: dial.c 1.2 Mon, 26 Oct 1998 00:32:12 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include "dbs.h"
#include "dbs_keys.h"

int	dbs_dial_string(int slot, char *text)
{
	char	dbuf[17];
	int	digits = 0;

	while(digits < 16 && *text)
		switch(*(text++))
		{
		case '0':
			dbuf[digits++] = DBS_KEY_10;
			break;
		case '1':
			dbuf[digits++] = DBS_KEY_1;
			break;
		case '2':
			dbuf[digits++] = DBS_KEY_2;
			break;
		case '3':
			dbuf[digits++] = DBS_KEY_3;
			break;
		case '4':
			dbuf[digits++] = DBS_KEY_4;
			break;
		case '5':
			dbuf[digits++] = DBS_KEY_5;
			break;
		case '6':
			dbuf[digits++] = DBS_KEY_6;
			break;
		case '7':
			dbuf[digits++] = DBS_KEY_7;
			break;
		case '8':
			dbuf[digits++] = DBS_KEY_8;
			break;
		case '9':
			dbuf[digits++] = DBS_KEY_9;
			break;
		case '*':
			dbuf[digits++] = DBS_KEY_STAR;
			break;
		case '#':
			dbuf[digits++] = DBS_KEY_POUND;
			break;
		case 'H':
			dbuf[digits++] = DBS_KEY_ONHOOK;
			break;
		case 'D':
			dbuf[digits++] = DBS_KEY_OFFHOOK;
			break;
		case 'W':
			dbuf[digits++] = DBS_KEY_HOLD;
			break;
		case 'F':
			dbuf[digits++] = DBS_KEY_FLASH;
			break;
		case 'C':
			dbuf[digits++] = DBS_KEY_CONF;
			break;
		case 'T':
		case 'X':
			dbuf[digits++] = DBS_KEY_XFER;
			break;
		case '!':
			dbuf[digits++] = DBS_KEY_FAIL;
			break;
		case 'R':
			dbuf[digits++] = DBS_KEY_RECOVER;
			break;
		case 'S':
			dbuf[digits++] = DBS_KEY_SPD;
			break;
		}

	dbuf[digits] = 0;
	
	return dbs_dial(slot, dbuf);
}

int	dbs_dial(int slot, char *text)
{
	DBSMSG	msg[DBS_DIAL_MSGLEN];
	int	digits = strlen(text);

	if(digits > 16)
		digits = 16;

	dbs_setslot(msg, slot);	
	dbs_setmsglen(msg, sizeof(msg));
	dbs_setmsgtype(msg, DBS_DIAL_MSGTYPE);
	msg[6] = digits;
	memset(msg + 7, 0, 16);
	strncpy(msg + 7, text, digits);
	return dbs_send(msg);
}	

int	dbs_dial_trunk(int slot, int trunk)
{
	char	dbuf[8];

	if(trunk)
		sprintf(dbuf, "D88%02d%s", trunk);
	else
		sprintf(dbuf, "D9");

	return dbs_dial_string(slot, dbuf);
}

int	dbs_dial_pickup(int slot)
{
	return dbs_dial_string(slot, "D");
}

int	dbs_dial_hangup(int slot)
{
	return dbs_dial_string(slot, "H");
}

int	dbs_dial_number(int slot, int trkgrp, char *nbr)
{
	char	pbuf[5];
	int	stat;

	if(trkgrp)
		sprintf(pbuf, "D8%d", trkgrp);
	else
		sprintf(pbuf, "D9");
	
	stat = dbs_dial_string(slot, pbuf);
	if(stat)
		return stat;

	if(nbr)
		return dbs_dial_string(slot, nbr);
}

int	dbs_dial_msgwait_on(int slot, int ext)
{
	char	pbuf[10];

	sprintf(pbuf, "D*4%dH", ext);
	return dbs_dial_string(slot, pbuf);
}

int	dbs_dial_msgwait_off(int slot, int ext)
{
	char	pbuf[10];

	sprintf(pbuf, "D*5%dH", ext);
	return dbs_dial_string(slot, pbuf);
}


		
	
