/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: dbs.h 1.7 Mon, 26 Oct 1998 00:32:12 -0500 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

typedef	unsigned	char	DBSMSG;

#define	APID_ACD		1
#define	APID_AA			2
#define	APID_VM			3

enum
{
	TLOG_DEBUG = 0,
	TLOG_INFO,
	TLOG_WARNING,
	TLOG_ERROR
};	

#define	DBS_POWERON_MSGTYPE	0x8400
#define	DBS_POWERON_MSGLEN	6

#define	DBS_INQUIRE_MSGTYPE	0x6001
#define	DBS_INQUIRE_MSGLEN	8

#define	DBS_SERVICE_MSGTYPE	0x8500
#define	DBS_SERVICE_MSGLEN	9

#define	DBS_MONITOR_MSGTYPE	0x4000
#define	DBS_MONITOR_MSGLEN	12

#define	DBS_DISPLAY_MSGTYPE	0x2900
#define	DBS_DISPLAY_MSGLEN	30

#define	DBS_APIKEY_MSGTYPE	0x0e00
#define	DBS_APIKEY_MSGLEN	13

#define	DBS_DIAL_MSGTYPE	0x0900
#define	DBS_DIAL_MSGLEN		23

#define	DBS_TRANSFER_MSGTYPE	0x9000
#define	DBS_TRANSFER_MSGLEN	17

#define	DBS_ANSWER_MSGTYPE	0x9100
#define	DBS_ANSWER_MSGLEN	11

#define	DBS_KEYPAD_MSGTYPE	0x2a00
#define	DBS_KEYPAD_MSGLEN	29

#define	DBS_TONE_MSGTYPE	0x0800
#define	DBS_TONE_MSGLEN		20

#define	INQUIRE_CACHE		0x80	/* use cache available		*/
#define	INQUIRE_WAIT		0x40	/* wait for next cache update	*/
#define	INQUIRE_INIT		0x20	/* no response sent		*/
#define	INQUIRE_IMMEDIATE	0x00	/* pass through cache live	*/
#define	INQUIRE_INITIALIZE	INQUIRE_CACHE | INQUIRE_INIT

#define	DBS_DISPLAY_UPDATE	0
#define	DBS_DISPLAY_MENU	1
#define	DBS_DISPLAY_CLEAR	2

#define	DTS_SETFLAG_MSGTYPE	0x8000
#define	DTS_SETFLAG_MSGLEN	7

#define	DTS_CLRFLAG_MSGTYPE	0x8001
#define	DTS_CLRFLAG_MSGLEN	7

/*	CHANNEL FLAGS		*/

#define	FLAG_KEYMON		0x80	/* get API key events		*/
#define	FLAG_ACDMON		0x40	/* get ACD events		*/
#define	FLAG_MAINT		0x20	/* get maint messages		*/
#define	FLAG_NOREPLY		0x02	/* no status reply messages	*/
#define	FLAG_SENDONLY		0x01	/* never receives		*/
#define	FLAG_NORECV		FLAG_SENDONLY

/*	DBS NUMBER TYPES	*/

#define	DBS_STATION_NUMBER	0
#define	DBS_TRUNK_NUMBER	1

#define	dbs_setapid(msg, id)	(msg[2] = id)
#define	dbs_getapid(msg)	(msg[2])
#define	dbs_setvtid(msg, id)	(msg[3] = id)
#define	dbs_getvtid(msg)	(msg[3])
#define	dbs_setmsglen(msg, len)	(msg[1] = len)
#define	dbs_getmsglen(msg)	(msg[1])

#define	DBS_NBR_SOURCE	0
#define	DBS_NBR_DIGITS	1
#define	DBS_NBR_DIGIT	2

#pragma	pack(1)
typedef	struct
{
	unsigned char   nbrtype;
	unsigned char	digits;
	unsigned char	nbr[3];
}	DBSNBR;

#pragma	pack()

#ifndef	__DBS_SERVER__

extern	int	dbs_stations, dbs_trunks, dbs_digits;

unsigned short dbs_getmsgtype(DBSMSG *msg);
short 	dbs_getextnbr(DBSMSG *msg);
short	dbs_getextension(DBSNBR *nbr);
void	dbs_setextension(DBSNBR *nbr, int ext);
void	dbs_settrunk(DBSNBR *nbr, int trunk);
void	dbs_setnumber(DBSNBR *nbr, int digits, int type);
void	dbs_setmsgtype(DBSMSG *msg, unsigned short mtype);
long	dbs_getbcd(DBSMSG *bcd, int digits);
void	dbs_setbcd(DBSMSG *bcd, long value, int digits);
 
int	dbs_connect(char *appname);
int	dbs_shutdown(void);
int	dbs_send(DBSMSG *msg);
int	dbs_recv(DBSMSG *msg);
char	*dbs_getstring(char *id, char *def);
long	dbs_getvalue(char *id, long def);
void	dbs_getappname(char *id, int len);

int	dbs_getslots(void);
void	dbs_setslots(char *str);
int	dbs_getslot(DBSMSG *msg);
void	dbs_setslot(DBSMSG *msg, int slot);
char	*dbs_getslotid(int slot);

int	dbs_poweron(int slot);
int	dbs_inquire(int slot, int port, unsigned char flags);
int	dbs_display(int slot, int ext, int line, char *text, int mode);
int	dbs_display_line(int slot, int ext, int line, char *text);
int	dbs_clear_line(int slot, int ext, int line);
int	dbs_display_clear(int slot, int ext);
int	dbs_display_menu(int slot, int ext);
int	dbs_monitor(int slot, int ext, unsigned char level);
int	dbs_dial(int slot, char *digits);
int	dbs_dial_string(int slot, char *digits);
int	dbs_dial_trunk(int slot, int trunk);
int	dbs_dial_pickup(int slot);
int	dbs_dial_hangup(int slot);
int	dbs_dial_number(int slot, int trkgrp, char *nbr);
int	dbs_answer(int slot, int ext);
int	dbs_transfer_extension(int slot, int target, int source);
int	dbs_transfer_trunk(int slot, int ext, int trunk);
int	dbs_service(DBSMSG *msg, int *status);
int	dbs_apikey(DBSMSG *msg, int *ext, int *keycode);
int	dbs_keypad(DBSMSG *msg, int *ext, int *port, char *keys);
int	dbs_tone(DBSMSG *msg, int *ext, int *tone, int *trunk); 

int     dts_syslog(int slot, int level, char *msg); 
int	dts_setflags(int slot, unsigned char flags);
int	dts_clrflags(int slot, unsigned char flags);

#endif
