/* DBS Telephony Server (c) 1997-1998 Tycho Softworks.
 * $Id: bcd.c 1.1 Sat, 19 Sep 1998 20:57:22 -0400 dyfet $
 *
 * This software is free software; permission is granted to use, modify
 * and redistribute this software as according to the terms of the GNU
 * General Public License as published by the Free Software Foundation;
 * either version 2, as found in the "COPYING" file distributed with this
 * software, or (at your option) any later version published by the
 * Free Software Foundation. 
 * 
 * This software is supplied "AS IS" WITHOUT ANY WARRANTY, EXPRESSED OR
 * IMPLIED; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for further details. 
 */

#include <std/string.h>
#include "dbs.h"

/* Produce DBS's 'packed' bcd format for extension numbers.  the DBSMSG*
 * is in this case the actual offset in the msg packet to use.
 */

long	dbs_getbcd(DBSMSG *bcd, int digits)
{
	unsigned	char	nibble;
	char	buf[9];
	char	*p = buf;

	/* always use even number of digits */

	if(digits & 1)
		++digits;
	
	while(digits--)
	{
		if(digits & 1)
			nibble = (*bcd & 0xf0) >> 4;
		else
			nibble = *(bcd++) & 0x0f;
		
		if(nibble == 0x0f)
			break;

		*(p++) = nibble + '0';
	}
	*p = 0;
	return atoi(buf);
}
			
void	dbs_setbcd(DBSMSG *bcd, long nbr, int digits)
{
	unsigned	char	nibble = 0;
	char	buf[11];
	char	*p = buf;

	strtol(buf, NULL, 10);
	if(digits & 1)
		++digits;

	while(digits--)
	{
		if(!*buf)
			nibble |= 0x0f;
		else
			nibble |= (*(p++) & 0x0f);

		if(digits & 1)
			nibble = nibble << 4;
		else
		{
			*(bcd++) = nibble;
			nibble = 0;
		}
	}
}

