
#include "process.p"

int switch_tty(char *requested_line)
{   
    int 
        index;
    char
        *default_line = get_default_tty();

    if (!strcmp(default_line, requested_line))      /* ok if already default */    
        return (1);

    for (index = 0; index != n_available; index++)
    {       
        char
            *try_line = available[index].line;
        if 
	(
	    !strcmp(try_line, requested_line)       /* line is available */
            &&
            available[index].state <= 0             /* and not busy */
        )
        {
            log(log_on, "switching to line '%s' for callback", try_line);
            activate_ttyline(lookup_tty(try_line));
            return (1);
        }
    }

    return (0);                                     /* no available line */
}

