
#include "process.p"

void modem_respawn()
{                                    
    int         
        kills;
    char
        *line;
               
    kills = 0;
    reset_active_tty();

    while ((line = get_active_tty()))           /* check all active lines */
    {                   
        int
            index;

        for (index = 0; index < n_available; index++)
        {                                       /* look for a line */
            if (!strcmp(line, available[index].line))
            {                  
                int
                    pid;
                                                /* try to kill the process */
                if (kill(pid = available[index].pid, SIGTERM))
  	    	    log(log_off,                /* doesn't work: log it */
		        "Can't 'kill(%d, SIGTERM)' for modemline '%s'", 
  		        pid, line);
                else
                {                               /* ok: maybe tell the log */
                    assign_filenames(line);
        	        log(log_on, 
			    "SIGTERM received by %s", getfile(the_modemfile));
                    kills++;
                }
                break;                          /* this for-loop's done. */
            }
        }                      
    }
    if (!kills)
	log(log_on, "No modem process(es) killed");
}
    
