
#include "process.p"

void linestate(char *processline)
{
    int 
        index,
        pid;
    char
        *cp,
        *modem,
        *line;

    processline[strlen(processline) - 1] = 0;   /* remove trailing \n */
        
    modem = getmodembase();

    if ((cp = strrchr(modem, '/')))             /* look for the last part of */
        modem = cp + 1;                         /* the modembase: beyond /   */

    log(log_max, "process: '%s'", processline);
    if (!strstr(processline, modem))
    {
/* no message implies:        log(log_max, "no modem process on this line"); */
        return;                                 /* no modem process */
    }

                                                /* walk all lines */
    for (index = 0; (line = get_ttyline(index)); index++)
    {
        if (strstr(processline, line))          
        {                                       /* modembase and line found */
	    if (sscanf(processline, " %d", &pid) != 1)
	    	log(log_off, "Can't find PID in ps-output '%s'", processline);
	    else 
            {
                int
                    state,  
                    userid;

                available = (AVAILLINE_ *)xrealloc(available, 
		            ++n_available * sizeof(AVAILLINE_));
                available[n_available - 1].pid = pid;
                available[n_available - 1].line = xstrdup(line);
                                            /* busy if getstate() returns > 0 */
                available[n_available - 1].state = getstate(&state, &userid);
                log(log_max, "line '%s': %s", 
		            line, 
                	    state > 0 ?
                                "busy calling back"
                            :
                                "available for callback");
            }
	}
    }
}
