#ifndef _log_H_
#define _log_H_

#include <stdio.h>
#include <stdarg.h>
#include <time.h>

#include "../mem/mem.h"
#include "../startup/startup.h"

typedef enum            /* messages at the level indicated by the       */
{                       /* 'log' setting in the setup file and lower    */
    log_off,            /* are logged.                                  */
    log_default,        /* In the sources a log value of the logtype    */
    log_on,             /* indicates a severe situation:                */
    log_max,            /* log_off: very serious, log_max: only minor   */
} LOG_TYPE_;

unsigned logdefaults();                         /* 0 if we're not to log the */
                                                /* default settings          */
char *get_logtypestring();
char *get_logfilename();
char *get_diallogfilename();
char *get_panicfilename();

void setlog(LOG_TYPE_ type);
void set_logdefaults();             
void setlogfilename(char *name);
void setdiallogfilename(char *name);
void setpanicfilename(char *name);

void log(LOG_TYPE_ minimum, char *fmt, ...);    /* generic log function */
void logv(char *fmt, va_list args);	        /* va-list log function */
                    
#endif  _log_H_
