
#include "dest.p"

int get_line_to_use(int dest)
{      
    char                            /* determine the default tty */
        *use_tty = get_default_tty(),
        *requested_line = destination[dest].line;

    availline_list();               /* determine the set of available lines */
    
    if (!requested_line)            /* no value -> use defaultline */
    {
        log(log_max, "using (default) ttyline: '%s'", use_tty);
        return (0);
    }
        
    if (!strcmp(requested_line, ""))/* empty-line: use any but the current */
    {
        use_tty = get_another_tty();

        if (!use_tty)
        {   
            log(log_off, "No alternate line available for callback");
            return (1);
        }

        log(log_on, "Using line '%s' for callback", use_tty);

        assign_filenames(use_tty);      /* use another ttyline */
        unlink_files();                 /* rm stale state- and disable files */
        atexit(modem_respawn);          /* kill the appropriate line at exit */
        return (0);
    }
    
    if (!switch_tty(requested_line))    /* can't switch tty */
    {
        log(log_off, "Line '%s' currently unavailable for callback",
            requested_line);
        return (1);
    }
    else
        log(log_on, "Using fixes line '%s' for callback", requested_line);

    assign_filenames(requested_line);    /* use another ttyline */
    unlink_files();                      /* rm stale state- and disable files */
    atexit(modem_respawn);               /* kill the appropriate line at exit */
    return (0);
}
