
#include "dbase.p"

void update_cbstate(char *line)
{
    int
        state;
    unsigned
        userid;
        
    switch (getstate(&state, &userid))
    {
        case -2:    /* expiry */
            log(log_on, "Callback expiry on line %s after %u seconds",
	                 line, maxage);
             enable_state();
        break;                         
               
        case -1:    /* absent file */
            if (!access(filename[the_disablefile], R_OK))
                log(log_on, "Incoming calls on line %s disabled", line);
            else
                log(log_on, "Standing by for incoming calls on line %s", line);
        break;

        case 0:     /* states exhausted */
            log(log_on, "Callback states on line %s exhausted: reenabling", 
	            line);
            enable_state();
        break; 
        
        default:
            log(log_on, "Callback state on line %s : %d for %s", 
	                 line, state, username(userid));
            state--;
            writestate(state, userid);
    }
}
