
#include "dbase.p"

int to_activefile(int dest, FILE *outf, FILE *inf)
{
    char
        *cp,
    	buf[300],
        outbuf[300],
	*marker;
    int
        copied = 0,
        len = 0;

    while (fgets(buf, 299, inf))                /* read an input line */
    {              
        copied = 1;
        if ((cp = strrchr(buf, '\n')))          /* remove \n at the end */
            *cp = 0;
    	    
        log(log_on, "->in: '%s'", buf);         /* log what we read */

    	if (!(marker = strstr(buf, PHONE)))	/* check $PHONE */
        {
            log(log_max, "No $PHONE marker in this line");
    	    strcpy(outbuf, buf);                /* copy the line as-is */
        }
    	else					/* otherwise, insert phonenr */
    	{	
            log(log_max, "Found $PHONE marker in this line");
            len = marker - buf;                 /* length of info to cp */
	    strncpy(outbuf, buf, len);          /* copy what's before marker */
	    sprintf                             /* append the phonenumber */
	    (
		outbuf + len, 
		        "%s%s",			
			get_phone(dest),
			marker + strlen(PHONE)	/* and the trailing info */
	    );
    	}

	log(log_on, "->out: '%s'", outbuf);     /* log what we write */

	if 
	(
	    (len = fprintf(outf, "%s\n", outbuf))  /* and write the new file */
            !=
            strlen(outbuf) + 1
        )
        {            
            copied = 0;
            break;
        }
    }    
    
    if (!copied)
        return (1);

    return (0);
}
