
#include "dbase.p"

/*
    Make a new active file for destination 'dest'
*/
void make_activefile(unsigned uid, int dest)
{
    FILE
    	*inf,
    	*outf,
        *logfile;
    time_t
        ltime;
    char
        name[10],      /* Username, reduced to 8 chars */
    	*fname;
    int
        ret;
    /*
	the source is either the name from the phonelist index, or when
	not given: the default callback definitions file
    */
    if (!(fname = get_filename(dest)))   /* sourcefile may be specified   */
        fname = filename[the_callbackfile];

    log(log_max, "make_activefile() to read %s", fname);
    
    inf = xfopen(fname, "r");		    /* open the callback-file	    */

    log(log_max, "make_activefile() to write %s", filename[the_activefile]);
    
					    /* and the temporary file   */
    outf = xfopen(filename[the_activefile], "w");
    	
    ret = to_activefile(dest, outf, inf);   /* copy info to active file */
    
    fclose (inf);
    fclose (outf);

    if (ret)                                /* error in copying, reset to */
    {                                       /* enable-state               */
        enable_state();
        error("Copy failure, resetting");
    }

    log(log_on, "make_active() copy to %s completed", filename[the_activefile]);

    if ((logfile = fopen (get_diallogfilename(), "a")))
    {
        time (&ltime);
        strncpy(name, username(uid), 8);   /* reduce username to 8 */
        name[8] = 0;
        fprintf
        (
            logfile,
                "%s"
                "calling %s at %s (%s V %s)\n"
            , ctime (&ltime)
            , name
            , get_dname(dest)
            , getprogname()
            , version
        );
 	fclose(logfile);
    }

    log(log_max, "make_active(): call logged on %s", get_diallogfilename());
}
