
#include "dbase.p"

char *fgetline(FILE *inf)
{
    static char
    	buf [500];				/* input buffer */
    register char
    	*cp;
    	
    while (1)
    {
    	fgets(buf, 499, inf);			/* try to read line */
    	
    	if (feof(inf))				/* return failure when */
    	   return (NULL);			/* at EOF */
    	   
    	if (buf[0] == '#')			/* ignore lines starting */
    	    continue;				/* with hashmark */
    	   
    	cp = buf + strlen(buf) - 1;		/* strip whitespace at end */
    	while (isspace(*cp) && cp > buf)
    	{
    	    *cp = '\0';
    	    cp--;
    	}
    	
    	if (cp == buf)				/* ignore empty lines */
    	    continue;
    	
    	cp = buf;				/* skip leading spaces */
    	while (isspace(*cp))
    	    cp++;
    	    
    	return (cp);				/* return that position */
    }
}
