
#include "cb.h"

void usage()
{
    preusage();

    printf("Where:\n"
	   "	-l: optional flag to log the defaults to '%s'.\n"
	   "\n"
	   "	action: Action to be taken. Select from:\n"
	   "	    disable	    : disables mgetty's dial-in\n"
    	   "	    enable	    : resets callback to waiting state\n"
    	   "	    file	    : shows mgetty's definition file\n"
    	   "	    init	    : restarts init to reload mgetty\n"
	   "%s"
	   "%s"
	   , get_logfilename()
	   , getmode() == mode_callback ?
		"	    list [who]	    : lists user-related information\n"
	    :
		""
	    , getmode() == mode_callback ?
		"	    state	    : shows state of callback\n"
	    :
		""
    );

    if (getmode() == mode_callback)
	printf
	(
    	   "	    %swho where%s  : forces callback to 'who' at 'where'\n"
	   , getcall() ? "call " : ""
	   , getcall() ? "" : "     "
	);

    printf(
    	   "\n"
           "	line: - the tty-line to use. Recognized lines are:\n"
	   "		ttyS1--ttyS9, 1--9, + (use all configured lines).\n"
	   "	      - If omitted, the default line is used.\n"
	   "	      - Ignored with 'init'%s.\n"
	   "\n"
	    , getmode() == mode_callback ?
		    ", 'list', and 'who'"
		:
		    ""
	   );

    error
    (
	"%s: %s MODE\n"
	"Actions may be abbreviated, e.g., \"in\" is equivalent to "
    	  						" \"init\".\n"
	, getprogname()
	, getmode() == mode_callback ?
		"CALLBACK"
	    :
		"DIAL-IN"
    );
}
