
#include "cb.h"

void force(char *who, char *where)
{
    register int
	uid,
	dest;

    if ((uid = lookuser(who)) > lastuser())
	error("No callback user '%s'.", who);
	
    if ((dest = combine(uid, where)) == -1)
	error("No callback destination '%s' for '%s'.", where, who);

    switch (get_destmode(dest))
    {
	case direct_mode:		/* direct requested ? */
	    error("Use telnet or VCs for direct logins.");

	case extra_mode:
	    ask_extra_number(uid, dest);	/* ask for extra destination */
	break;

	default:			/* to catch the phonemode */
    }
	
    log(log_default, "Calling %s at %s", who, where);

    if (get_line_to_use(dest))          /* determine the ttyline to be used */
    {
        printf
        (
            "\n"
            "No line available to callback %s at %s.\n"
            , who
            , where
        );
        return;
    }

    assign_filenames(get_active_tty());

    setcallback(uid, dest);		/* set the callbackfile */

    modem_respawn();
}
