#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <pwd.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <termios.h>
#include <utmp.h>
#include "common.h"

int	getString(char *s, int len);
int	userFileSearchPhNo(word phNoArea, word phNoLocal);
void	modemWrite(char *s);
int	modemExpect(char *s, int timeout);
void	cfmakesane(struct termios *tio);

int	nProcs;
ProcRec procRec[MAX_PROCS];

void main() {
  int i, j, len, ok;
  int ttyDev;
  char *devPath, password[9], lockFilePath[32] = "", login[MAX_LOGINCHARS + 1], phNo[32], line[256];
  BanRec br;
  word phNoArea, phNoLocal;
  time_t t;
  struct stat _stat;
  int modemFD;
  FILE *lockFile;
  struct termios saveTermios, tio;
  pid_t pid = getpid();
  processConfig();
  setuid(0); setgid(0);
  setenv("LOGNAME", "root", 1);
  devPath = ttyname(STDIN_FILENO);
  stat(devPath, &_stat);
  ttyDev = _stat.st_rdev;
  if (lineNo(ttyDev) < 0)
    errQuit("stdin not a dial-up line -- aborting.");
  for (i = strlen(devPath) - 1; devPath[i] != '/'; i--); i++;
  sprintf(lockFilePath, "/var/lock/LCK..%s", devPath + i);
  ok = 0;
  while (!ok) {
    ok = 1;
    printf("Enter your username: ");
    len = getString(line, 255);
    ok = (len >= 3 && len <= MAX_LOGINCHARS && islower(line[0]));
    if (ok) {
      strcpy(login, line);
      for (len = strlen(login), i = 0; i < len; i++)
        if (!islower(login[i]) && !isdigit(login[i])) {
          ok = 0;
	  break;
        }
    }
    if (!ok) {
      printf("\nA username must be 3-%d alpha/numeric characters.\n\n", MAX_LOGINCHARS);
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
      continue;
    }
    if (getpwnam(login)) {
      ok = 0;
      printf("\nThat username is already in use.\n\n");
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
    }
  }
  ok = 0;
  while (!ok) {
    ok = 1;
    printf("Enter your phone number: ");
    getString(phNo, 31);
    if (phNo2Words(&phNoArea, &phNoLocal, phNo, phNoDigits) ||
	(phNoArea && !phNoLocal))
    {
      ok = 0;
      printf("\nThat is not a valid phone number.\n\n");
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
      continue;
    }
    if (phNoArea) {
      ok = 0;
      printf("\nThat is a long distance number.\n\n");
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
      continue;
    }
    userFileOpen();
    i = userFileSearchPhNo(phNoArea, phNoLocal);
    userFileClose();
    if (!i) {
      ok = 0;
      printf("\nThat phone number is already in use.\n\n");
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
      continue;
    }
    banFileOpen();
    i = banFileSearch(&br, phNoArea, phNoLocal);
    banFileClose();
    if (!i) {
      ok = 0;
      printf("\nThat phone number has been BANNED.\n\n");
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
      continue;
    }
  }
  time(&t);
  srand(t);
  for (i = 0; i < 8; i++)
    password[i] = 'a' + random() % 26;
  password[i] = '\0';
  printf("\nNow I will hang up and call you back.  When your phone rings,\n"
         "do \"AT A\" to answer.  For authentication, you will be required\n"
         "to supply the following password: %s\n\n", password);
  printf("Press ENTER to continue: ");
  if (getchar() != '\n') goto fail;
  printf("\n");

  /* detach the tty */
  if ((i = open("/dev/tty", O_RDWR)) >= 0) {
    ioctl(i, TIOCNOTTY, NULL);
    close(i);
  }
  setpgid(0, 0);

  /* kill all processes attached to this terminal */
  sleep(2);
  signal(SIGHUP, SIG_IGN);
  procList(&nProcs, procRec);
  for (i = 0; i < nProcs; i++)
    if (procRec[i].tty == ttyDev && procRec[i].pid != pid)
      kill(procRec[i].pid, SIGTERM);
  sleep(5);
  for (i = 0; i < nProcs; i++)
    if (procRec[i].tty == ttyDev && procRec[i].pid != pid)
      kill(procRec[i].pid, SIGKILL);

  /* fix up STDIN, STDOUT, STDERR */
  sleep(5);
  j = 0;
  while (!access(lockFilePath, F_OK)) {
    usleep(100000);	/* sleep 1/10 of a second */
    if (++j == 150) goto fail;
  }
  lockFile = fopen(lockFilePath, "w"); assert(lockFile != NULL);
  fprintf(lockFile, "%010d user_verify root\n", (int)pid);
  fclose(lockFile);
  modemFD = open(devPath, O_RDWR | O_NONBLOCK | O_NOCTTY);
  if (modemFD < 0) goto fail;
  fcntl(modemFD, F_SETFL, O_RDWR);
  for (i = 0; i <= 2; i++) dup2(modemFD, i);
  if (modemFD >= 3) close(modemFD);
  setvbuf(stdin, NULL, _IONBF, 0);
  setvbuf(stdout, NULL, _IONBF, 0);
  setvbuf(stderr, NULL, _IONBF, 0);
  tcgetattr(STDIN_FILENO, &saveTermios);
  tio = saveTermios;
  cfmakesane(&tio);
  cfmakeraw(&tio);
  tcsetattr(STDIN_FILENO, TCSANOW, &tio);

  /* do the verification */
  strcpy(line, modemDial);
  for (i = 0, len = strlen(line); ; len++) {
    for (; !isdigit(phNo[i]) && phNo[i] != '\0'; i++);
    if (phNo[i] == '\0') break;
    else line[len] = phNo[i++];
  }
  line[len++] = '\r';
  line[len++] = '\0';
  modemWrite(line);
  if (modemExpect("CONNECT", 60)) { 
    tcsetattr(STDIN_FILENO, TCSANOW, &saveTermios);
    goto fail;
  }
  sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
  cfmakesane(&tio);
  tcsetattr(STDIN_FILENO, TCSANOW, &tio);
  printf("\n\n");
  for (i = 0; i < 3; i++) {
    printf("Enter the password: ");
    getString(line, 8);
    if (!strcmp(line, password)) break;
    else if (i != 2) {
      printf("\nIncorrect -- try again.\n\n");
      sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
    }
  }
  if (i == 3) goto fail;
  printf("\nCorrect -- your account will be created now.\n\n");
  sleep(2); tcflush(STDIN_FILENO, TCIOFLUSH);
  if (!runCommand(SBIN"/user_add", login, phNo, NULL)) {
    printf("\nYour account has been created.\n\n");
    sleep(2);
  }
fail:
  unlink(lockFilePath);
  exit(0);
}

int getString(char *s, int len) {
  int res;
  char line[256];
  fd_set rSet;
  struct timeval tv;
  fflush(stdout);
  FD_ZERO(&rSet);
  FD_SET(STDIN_FILENO, &rSet);
  tv.tv_sec = 60;
  tv.tv_usec = 0;
  if (select(STDIN_FILENO + 1, &rSet, NULL, NULL, &tv) <= 0) {
    s[0] = '\0';
    return 0;
  }
  fgets(line, 256, stdin);
  res = strlen(line);
  if (res > len) {
    res = len;
    line[res] = '\0';
  } else if (res && line[res - 1] == '\n') line[--res] = '\0';
  strncpy(s, line, res);
  s[res] = '\0';
  return res;
}

int userFileSearchPhNo(word phNoArea, word phNoLocal) {
  UserRec ur;
  rewind(userFile);
  while (!userFileRead(&ur))
    if (ur.phNoArea == phNoArea && ur.phNoLocal == phNoLocal)
      return 0;
  return 1;
}

void modemWrite(char *s) {
  int i, l = strlen(s);
  char nl = 10, cr = 13; 
  for (i = 0; i < l; i++) {
    if (s[i] == '\\') {
      i++;
      switch(s[i]) {
      case 'd': usleep(500000); break;
      case 'n': fputc(nl, stdout); break;
      case 'r': fputc(cr, stdout); break;
      case '\\': fputc(s[i], stdout); break;
      }
    } else if (s[i] == '~') usleep(100000);
    else fputc(s[i], stdout);
    usleep(100000);
  }
}

int modemExpect(char *s, int timeout) {
  int match_len = 0, s_len = strlen(s);
  fd_set rSet, allSet;
  struct timeval tv;
  time_t t, t2;
  time(&t);
  FD_ZERO(&allSet);
  FD_SET(STDIN_FILENO, &allSet);
  for (;;) {
    time(&t2);
    if (t2 - t >= timeout) return 1;
    tv.tv_sec = timeout - (t2 - t);
    tv.tv_usec = 0;
    rSet = allSet;
    if (select(STDIN_FILENO + 1, &rSet, NULL, NULL, &tv) <= 0) return 1;
    if (fgetc(stdin) == s[match_len]) {
      if (++match_len == s_len) return 0;
    } else match_len = 0;
  }
}

void cfmakesane(struct termios *tio) {
  tio->c_iflag = ICRNL | BRKINT | IGNPAR | IXON | IXANY;
#if defined(LINUX)
  tio->c_oflag = OPOST | ONLCR | TAB3;
#elif defined(BSD)
  tio->c_oflag = OPOST | ONLCR | OXTABS;
#endif
  tio->c_cflag &= ~(CSIZE | CSTOPB | PARENB | PARODD | CLOCAL);
  tio->c_cflag |= CS8 | CREAD | HUPCL;
  tio->c_lflag = ECHOK | ECHOE | ECHO | ISIG | ICANON;
}
