#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <limits.h>
#if defined(LINUX)
#include <linux/if.h>
#include <linux/if_ppp.h>
#include <linux/ppp_defs.h>
#elif defined(BSD)
#include <net/if.h>  
#include <net/if_ppp.h>  
#include <net/ppp_defs.h>  
#endif
#include <paths.h>
#include <pwd.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdlib.h>
#include <sys/dir.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <syslog.h>
#include <utime.h>
#include "common.h"

#define		MAX_PPP_UNITS			MAX_USERS
#define		PUNT_BUSY			0
#define		PUNT_DATA_PERIOD		1
#define		PUNT_DATA_SESSION		2
#define		PUNT_TIME_IDLE			3
#define		PUNT_TIME_CLASS			4
#define		PUNT_TIME_PERIOD	       	5
#define		PUNT_TIME_SESSION      		6

typedef struct VictimRec {
  uid_t		uid;
  dev_t		devNo;
  char		devName[12];
  int		priority, sLeft;
  int		reason;
  int		sendMail;
} VictimRec;

void		daemonInit();
void		update();
char		*userTTY(char *devPath, int uid);
void		userMessage(char *login, char *devName, char *format, ...);
int		PPPidleLeft(char *ttyPath);
void		PPPupdate(UserRec *ur, int unit);
void		PPPfindUnits();
int		PPPfindUnit(uid_t uid);
int		victimCmp(const VictimRec *v1, const VictimRec *v2);

const char	*msgTimeWarning = "You have %d minute(s) remaining.";
const char	*msgIdleWarning = "You will be logged out after 1 more minute of idle time.";
const char	*msgPath[7] = { LIB"/user_updated.busy", LIB"/user_updated.data_period", LIB"/user_updated.data_session",  LIB"/user_updated.idle", LIB"/user_updated.time_class", LIB"/user_updated.time_period", LIB"/user_updated.time_session" };
const char	*puntReason[7] = { "system busy", "data limit exceeded", "session data limit exceeded", "idle time limit exceeded", "class time limit exceeded", "time limit exceeded", "session time limit exceeded" };

int		runAsDaemon = 1, effect = 1, loggingLevel = 1;
char		MAILHOST[64];
time_t		configTime;
int		systemBusy;
int		nLogins;
LoginRec	loginRec[MAX_USERS];
int		nProcs;
ProcRec		procRec[MAX_PROCS];
uid_t		guestUID;
uid_t		PPPuser[MAX_PPP_UNITS];
int		nVictims;
VictimRec	victim[MAX_USERS];
int		nKill;
pid_t		killPID[MAX_PROCS];

void main(int argc, char **argv) {
  int i;
  struct stat _stat;
  time_t t;
  struct tm *tmP;
  char str[32];
  processConfig(); configTime = time(NULL);
  while ((i = getopt(argc, argv, "del")) != EOF) {
    switch (i) {
    case 'd': runAsDaemon = 0; break;
    case 'e': effect = 0; break;
    case 'l': loggingLevel = atoi(argv[optind++]); break;
    }
  }
  if (runAsDaemon) daemonInit();
  sprintf(str, "user_updated[%d]", (int)getpid());
  openlog(str, 0, LOG_DAEMON);
  guestUID = UIDfromLogin("guest");
  if (getenv("MAILHOST")) strcpy(MAILHOST, getenv("MAILHOST"));
  for (;;) {
    if (loggingLevel >= 9) syslog(LOG_DEBUG, "Stayin' alive...Stayin' alive...");
    if (stat(configFilePath, &_stat) < 0)
      perrQuit("couldn't stat %s", configFilePath);
    if (_stat.st_mtime > configTime) {
      processConfig();
      if (configTime && loggingLevel >= 1)
        syslog(LOG_INFO, "re-read %s", configFilePath);
      configTime = _stat.st_mtime;
    }
    if (loggingLevel >= 9) syslog(LOG_DEBUG, "userList()");
    userList(&nLogins, loginRec);
    if (loggingLevel >= 9) syslog(LOG_DEBUG, "procList()");
    procList(&nProcs, procRec);
    if (loggingLevel >= 9) syslog(LOG_DEBUG, "maxKick()");
    systemBusy = maxKick(nProcs, procRec);
    PPPfindUnits();
    update();
    if (effect && nKill) {
      int i;
      sleep(5);
      for (i = 0; i < nKill; i++)
	kill(killPID[i], SIGKILL);
    }
    time(&t);
    tmP = localtime(&t);
    if (loggingLevel >= 9) syslog(LOG_DEBUG, "sleep(%d)", 60 - tmP->tm_sec);
    sleep(60 - tmP->tm_sec);
  }
}

void daemonInit() {
  int i;
  if (fork()) exit(0);
  for (i = 0; i <= 2; i++) close(i);
  setsid();
  chdir("/");
  umask(0);
}

void update() {
  char login[MAX_LOGINCHARS + 1], devPath[32], str[256];
  int i, j, PPPunit, idleLeft, sLeft;
  int curClass, deductTime, deductSession;
  struct stat _stat;
  UserRec ur;
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "update()");
  nVictims = 0;
  nKill = 0;
  userFileOpen();
  while (!userFileRead(&ur)) {
    for (i = 0; i < nProcs && ur.uid != procRec[i].uid && ur.uid != procRec[i].euid; i++);
    if (i == nProcs) continue;
    for (j = i; j < nProcs; j++)
      if ((ur.uid == procRec[j].uid || ur.uid == procRec[j].euid) && 
          (lineNo(procRec[j].tty) >= 0))
	break;
    if (j == nProcs) continue;
    loginFromUID(login, ur.uid);
    if (!userTTY(devPath, procRec[i].uid)) continue;
    curClass = curTimeClass(&ur);
    PPPunit = PPPfindUnit(ur.uid);
    if (PPPunit >= 0) PPPupdate(&ur, PPPunit);
    /* update their record */
    deductTime = deductSession = 1;
    for (j = 0; j < nTimeClasses; j++) {
      if (inTimeClass(j)) {
	if (ur.cLimit[j] <= -3) deductTime = 0;
	if (ur.cLimit[j] <= -2) deductSession = 0;
	if (ur.cLimit[j] >= 0)
	  ur.cLeft[j]--;
      }
    }
    if (deductTime) ur.tLeft--;
    if (deductSession) ur.sLeft--;
    time(&ur.last);
    if (effect) userFileEdit(&ur);
    sLeft = INT_MAX;
    /* figure out how much time they have left */
    if ((!SMARTBOOT(ur.flags) || systemBusy) && ur.tLimit >= 0) sLeft = min(sLeft, ur.tLeft);
    if ((!SSMARTBOOT(ur.flags) || systemBusy) && ur.sLimit >= 0) sLeft = min(sLeft, ur.sLeft);
    if ((!TCSMARTBOOT(ur.flags) || systemBusy) && curClass >= 0 && ur.cLimit[curClass] >= 0)
      sLeft = min(sLeft, ur.cLeft[curClass]);
    if (!PRIORITY(ur.flags) && systemBusy) sLeft = min(sLeft, -(ur.sLimit - ur.sLeft));
    /* figure out how much idle time they have left */
    if (optIdleBoot && IBOOT(ur.flags)) {
      if (PPPunit >= 0) idleLeft = PPPidleLeft(devPath);
      else {
	if (stat(devPath, &_stat)) continue;
	idleLeft = optIdleBoot * 60 - (time(NULL) - _stat.st_atime);
      }
      if (idleLeft < 0) idleLeft = 0;
      else idleLeft = idleLeft / 60 + 1;
    } else idleLeft = INT_MAX;
    /* send a warning message if necessary */
    if (effect && PPPunit < 0) {
      if (idleLeft == 1 && sLeft > 1) 
	userMessage(login, devPath + 5, (char*)msgIdleWarning);
      else for (j = 0; j < nBootWarnTimes; j++)
	if (sLeft == bootWarnTime[j]) {
	  userMessage(login, devPath + 5, (char*)msgTimeWarning, sLeft);
	  break;
	}
    }
    /* take idle time into account */
    if (!ISMARTBOOT(ur.flags) || systemBusy) sLeft = min(sLeft, idleLeft);
    /* victimize this user if necessary */
    if (sLeft <= 0 || (ur.btLimit && ur.bTotal > ur.btLimit) || (ur.bsLimit && ur.bSession > ur.bsLimit)) {
      victim[nVictims].uid = ur.uid;
      victim[nVictims].devNo = devNumFromName(devPath + 5);
      strcpy(victim[nVictims].devName, devPath + 5);
      victim[nVictims].priority = PRIORITY(ur.flags);
      victim[nVictims].sLeft = sLeft;
      if (ur.tLeft <= 0) victim[nVictims].reason = PUNT_TIME_PERIOD;
      else if (ur.sLeft <= 0) victim[nVictims].reason = PUNT_TIME_SESSION;
      else if (curClass >= 0 && ur.cLimit[curClass] >= 0 && ur.cLeft[curClass] <= 0) victim[nVictims].reason = PUNT_TIME_CLASS;
      else if (idleLeft <= 0) victim[nVictims].reason = PUNT_TIME_IDLE;
      else if (ur.btLimit && ur.bTotal > ur.btLimit) victim[nVictims].reason = PUNT_DATA_PERIOD;
      else if (ur.bsLimit && ur.bSession > ur.bsLimit) victim[nVictims].reason = PUNT_DATA_SESSION;
      else victim[nVictims].reason = PUNT_BUSY;
      victim[nVictims++].sendMail = optSendMail && PPPunit >= 0 && ur.tLimit > 0;
      if (!optMaxKick) for (; i < nProcs; i++)
        if ((ur.uid == procRec[i].uid) || (ur.uid == procRec[i].euid))
          killPID[nKill++] = procRec[i].pid;
    }
  }
  userFileClose();
  for (i = 0; i < nLogins; i++) {
    if (loginRec[i].uid != guestUID) continue;
    sprintf(devPath, "/dev/%s", loginRec[i].tty);
    sLeft = optGuestTime * 60 - (time(NULL) + 5 - loginRec[i].time);
    if (sLeft > -60 && sLeft < 0) sLeft = -60;
    sLeft = sLeft / 60 + 1;
    if (!optGuestPriority && systemBusy) sLeft = min(sLeft, -(optGuestTime - sLeft));
    if (optIdleBoot) {
      if (stat(devPath, &_stat)) continue;
      idleLeft = optIdleBoot * 60 - (time(NULL) - _stat.st_atime);
      if (idleLeft < 0) idleLeft = 0;
      else idleLeft = idleLeft / 60 + 1;
    } else idleLeft = INT_MAX;
    if (effect) {
      if (idleLeft == 1 && sLeft > 1)
	userMessage("guest", loginRec[i].tty, (char*)msgIdleWarning);	
      else for (j = 0; j < nBootWarnTimes; j++)
	if (sLeft == bootWarnTime[j]) {
	  userMessage("guest", loginRec[i].tty, (char*)msgTimeWarning, sLeft);
	  break;
	}
    }
    /* take idle time into account */
    if (!optIdleSmartBoot || systemBusy) sLeft = min(sLeft, idleLeft);
    if (sLeft <= 0) {
      victim[nVictims].uid = guestUID;
      victim[nVictims].devNo = devNumFromName(loginRec[i].tty);
      strcpy(victim[nVictims].devName, loginRec[i].tty);
      victim[nVictims].priority = optGuestPriority;
      victim[nVictims].sLeft = sLeft;
      if (sLeft <= 0) victim[nVictims].reason = PUNT_TIME_SESSION;
      else if (idleLeft <= 0) victim[nVictims].reason = PUNT_TIME_IDLE;
      else victim[nVictims].reason = PUNT_BUSY;
      victim[nVictims++].sendMail = 0;
      if (!optMaxKick) for (j = 0; j < nProcs; j++)
	if (procRec[j].tty == victim[nVictims].devNo) killPID[nKill++] = procRec[j].pid;
    }
  }
  if (optMaxKick) {
    if (nVictims > systemBusy) {
      qsort(victim, nVictims, sizeof(VictimRec), (int (*)(const void*, const void*))victimCmp);
      nVictims = systemBusy;
    }
    for (i = 0; i < nVictims; i++)
      for (j = 0; j < nProcs; j++)
	if (victim[i].uid == guestUID) {
	  if (procRec[j].tty == victim[i].devNo)
	    killPID[nKill++] = procRec[j].pid;
	} else if (procRec[j].uid == victim[i].uid || procRec[j].euid == victim[i].uid)
	  killPID[nKill++] = procRec[j].pid;
  }
  if (effect) for (i = 0; i < nKill; i++) {
    if (loggingLevel >= 9) syslog(LOG_INFO, "kill(%d, SIGTERM)", (int)killPID[i]);
    kill(killPID[i], SIGTERM);
  }
  if (effect) for (i = 0; i < nVictims; i++) {
    if (loggingLevel >= 1) {
      loginFromUID(login, victim[i].uid);
      syslog(LOG_INFO, "Punted %s on %s (%s)", login, victim[i].devName, puntReason[victim[i].reason]);
    }
    if (victim[i].sendMail) {
      char mailDest[64];
      loginFromUID(mailDest, victim[i].uid);
      if (MAILHOST[0]) sprintf(mailDest + strlen(mailDest), "@%s", MAILHOST);
      sprintf(str, "mail -s \"Connection Terminated\" %s < %s", mailDest, msgPath[victim[i].reason]);
      system(str);
    }
  }
}

char *userTTY(char *devPath, int uid) {
  int i;
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "userTTY(%d)", (int)uid);
  for (i = 0; i < nLogins; i++)
    if (loginRec[i].uid == uid) {
      sprintf(devPath, "/dev/%s", loginRec[i].tty);
      return devPath;
    }
  devPath[0] = '\0';
  return NULL;
}

void userMessage(char *login, char *devName, char *format, ...) {
  int fd;
  FILE *f;
  char devPath[16], line[256];
  struct stat _stat;
  struct utimbuf _utime;
  va_list ap;
  va_start(ap, format);
  sprintf(devPath, "/dev/%s", devName);
  if (stat(devPath, &_stat)) goto l0;
  if (!(_stat.st_mode & S_IWGRP)) goto l0;
  vsprintf(line, format, ap);
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "userMessage(%s, %s, %s)", login, devName, line);
  fd = open(devPath, O_WRONLY | O_NONBLOCK | O_NOCTTY);
  if (fd >= 0) {
    f = fdopen(fd, "w");
    fputc(7, f);	/* send ^G */
    fprintf(f, "\n\nNOTICE: ");
    fprintf(f, "%s\n\n", line);
    fclose(f);
  }
  if (optIdleBoot) {
    _utime.actime = _utime.modtime = _stat.st_atime;
    utime(devPath, &_utime);
  }
l0:
  va_end(ap);
}

int PPPidleLeft(char *ttyPath) {
  struct ppp_idle _ppp_idle;
  int res = 0, fd = open(ttyPath, O_WRONLY | O_NONBLOCK | O_NOCTTY);
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "PPPidleLeft(%s)", ttyPath);
  if (fd < 0) return res;
  if (!ioctl(fd, PPPIOCGIDLE, &_ppp_idle))
    res = optIdleBoot * 60 - min(_ppp_idle.xmit_idle, _ppp_idle.recv_idle);
  close(fd);
  return res;
}

void PPPupdate(UserRec *ur, int PPPunit) {
  struct ifreq _ifreq;
  struct ppp_stats _ppp_stats;
  int s;
  word bSession;
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "PPPupdate(%d, %d)", (int)ur->uid, PPPunit);
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) perrQuit("couldn't create socket");
  bzero(&_ifreq, sizeof(struct ifreq));
#if defined(LINUX)
  sprintf(_ifreq.ifr_ifrn.ifrn_name, "ppp%d", PPPunit);
#elif defined(BSD)
  sprintf(_ifreq.ifr_name, "ppp%d", PPPunit);
#endif
  _ifreq.ifr_ifru.ifru_data = (caddr_t)&_ppp_stats;
  if (ioctl(s, SIOCGPPPSTATS, (caddr_t)&_ifreq) < 0) goto err;
#if defined(LINUX)
  bSession = _ppp_stats.p.ppp_ioctects + _ppp_stats.p.ppp_ooctects;
#elif defined(BSD)
  bSession = _ppp_stats.p.ppp_ibytes + _ppp_stats.p.ppp_obytes;
#endif
  if (bSession > ur->bSession) {
    ur->bTotal += bSession - ur->bSession;
    ur->bSession = bSession;
  }
err:
  close(s);
}

void PPPfindUnits() {
  int i, len, PPPunit;
  DIR *d;
  FILE *f;
  pid_t pid;
  struct dirent *de;
  int unitStrLen;
  char unitStr[8], str[32];
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "PPPfindUnits()");
  for (i = 0; i < MAX_PPP_UNITS; i++) PPPuser[i] = (uid_t)-1;
  if ((d = opendir(_PATH_VARRUN)) == NULL) perrQuit("opendir failed");
  while ((de = readdir(d)) != NULL) {
    len = strlen(de->d_name);
    if (len < 8 || len > 10) continue;
    if (strncmp(de->d_name, "ppp", 3)) continue;
    if (strcmp(de->d_name + len - 4, ".pid")) continue;
    for (unitStrLen = 0, i = 3; isdigit(de->d_name[i]); i++)
      unitStr[unitStrLen++] = de->d_name[i];
    unitStr[unitStrLen] = '\0';
    PPPunit = atoi(unitStr);
    if (PPPunit >= MAX_PPP_UNITS) continue;
    sprintf(str, "%s/ppp%d.pid", _PATH_VARRUN, PPPunit);
    if ((f = fopen(str, "r")) == NULL) continue;
    fgets(str, 32, f);
    pid = atoi(str);
    fclose(f);
    for (i = 0; i < nProcs; i++)
      if (!strcmp(procRec[i].name, "pppd") && procRec[i].pid == pid) {
	PPPuser[PPPunit] = procRec[i].uid;
	break;
      }
  }
  closedir(d);
}

int PPPfindUnit(uid_t uid) {
  int i;
  if (loggingLevel >= 9) syslog(LOG_DEBUG, "PPPfindUnit(%d)", (int)uid);
  for (i = 0; i < MAX_PPP_UNITS; i++)
    if (PPPuser[i] == uid) return i;
  return -1;
}

int victimCmp(const VictimRec *v1, const VictimRec *v2) {
  int v1Data = v1->reason == PUNT_DATA_PERIOD || v1->reason == PUNT_DATA_SESSION;
  int v2Data = v2->reason == PUNT_DATA_PERIOD || v2->reason == PUNT_DATA_SESSION;
  if (v1Data && !v2Data) return -1;
  else if (v2Data && !v1Data) return 1;
  else if (v1->priority == v2->priority) {
    if (v1->sLeft == v2->sLeft) return 0;
    else if (v1->sLeft < v2->sLeft) return -1;
    else return 1;
  } else if (v1->priority < v2->priority) return -1;
  else return 1;
}
