#include <assert.h>
#include <unistd.h>
#include "common.h"

void main(int argc, char **argv) {
  int i;
  uid_t uid;
  UserRec ur;
  processConfig();
  if (argc != 2)
    errQuit("usage: user_unsubscribe <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t)-1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  if (EXPIRE(ur.flags) != EXPIRE_UNSUBSCRIBE)
    errQuit("user does not have a subscription: %s", argv[1]);
  ur.flags = ur.subFlags;
  ur.expire = ur.subExpire;
  ur.tLimit = ur.tLeft = ur.subTlimit;
  ur.sLimit = ur.sLeft = ur.subSlimit;
  for (i = 0; i < MAX_TIME_CLASSES; i++)
    ur.cLeft[i] = ur.cLimit[i] = ur.subClimit[i];
  ur.btLimit = ur.subBTlimit;
  ur.bsLimit = ur.subBSlimit;
  ur.subFlags = 0;
  ur.subExpire = 0;
  ur.subTlimit = 0;
  ur.subSlimit = 0;
  for (i = 0; i < MAX_TIME_CLASSES; i++)
    ur.subClimit[i] = -1;
  ur.subBTlimit = ur.subBSlimit = 0;
  userFileEdit(&ur);
  userFileClose();
  printf("user unsubscribed: %s\n", argv[1]);
  exit(0);
}
